/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.nio.DefaultHttpServerIODispatch;
import org.apache.http.impl.nio.DefaultNHttpServerConnectionFactory;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.protocol.BasicAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerMapper;
import org.apache.http.nio.protocol.HttpAsyncService;
import org.apache.http.nio.protocol.UriHttpAsyncRequestHandlerMapper;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.util.DaemonThreadFactory;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    public static final ThreadGroup HTTP_THREAD_GROUP = new ThreadGroup("Http");
    private static final Logger LOGGER;
    private final UriHttpAsyncRequestHandlerMapper registry;
    private final IOEventDispatch ioEventDispatch;
    private final IOReactorConfig ioReactorConfig;
    private final InetSocketAddress httpInterface;
    private ThreadFactory threadFactory = new DaemonThreadFactory("Http#", HTTP_THREAD_GROUP);
    private ListeningIOReactor ioReactor;

    public HttpServer(NetworkConfig config, int httpPort) {
        this(config, new InetSocketAddress(httpPort));
    }

    public HttpServer(NetworkConfig config, InetSocketAddress httpInterface) {
        if (httpInterface == null) {
            throw new NullPointerException("http interface must not be null!");
        }
        this.httpInterface = httpInterface;
        HttpRequestInterceptor[] requestInterceptors = new HttpRequestInterceptor[]{new RequestAcceptEncoding()};
        HttpResponseInterceptor[] responseInterceptors = new HttpResponseInterceptor[]{new ResponseContentEncoding(), new ResponseDate(), new ResponseServer(), new ResponseContent(), new ResponseConnControl()};
        ImmutableHttpProcessor httpProcessor = new ImmutableHttpProcessor(requestInterceptors, responseInterceptors);
        this.registry = new UriHttpAsyncRequestHandlerMapper();
        HttpAsyncService protocolHandler = new HttpAsyncService((HttpProcessor)httpProcessor, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory(), (HttpAsyncRequestHandlerMapper)this.registry, null);
        DefaultNHttpServerConnectionFactory connFactory = new DefaultNHttpServerConnectionFactory(ConnectionConfig.DEFAULT);
        this.ioEventDispatch = new DefaultHttpServerIODispatch((NHttpServerEventHandler)protocolHandler, (NHttpConnectionFactory)connFactory);
        int socketTimeout = config.getInt("HTTP_SERVER_SOCKET_TIMEOUT");
        int socketBufferSize = config.getInt("HTTP_SERVER_SOCKET_BUFFER_SIZE");
        this.ioReactorConfig = IOReactorConfig.custom().setRcvBufSize(socketBufferSize).setSoTimeout(socketTimeout).setTcpNoDelay(true).setSoLinger(0).build();
    }

    UriHttpAsyncRequestHandlerMapper getRequestHandlerMapper() {
        return this.registry;
    }

    public void start() throws IOException {
        this.ioReactor = new DefaultListeningIOReactor(this.ioReactorConfig, this.threadFactory);
        this.ioReactor.listen((SocketAddress)this.httpInterface);
        Thread listener = new Thread("Http-Listener"){

            @Override
            public void run() {
                try {
                    HttpServer.this.ioReactor.execute(HttpServer.this.ioEventDispatch);
                }
                catch (IOException e) {
                    LOGGER.error("I/O Exception in HttpServer", (Throwable)e);
                }
            }
        };
        listener.setDaemon(false);
        listener.start();
        LOGGER.info("HttpServer listening on {} started.", (Object)StringUtil.toDisplayString((InetSocketAddress)this.httpInterface));
    }

    public void stop() {
        try {
            this.ioReactor.shutdown(1000L);
            System.out.println("shutdown ...");
        }
        catch (IOException e) {
            LOGGER.error("shutdown failed!", (Throwable)e);
        }
        LOGGER.info("HttpServer on {} stopped.", (Object)StringUtil.toDisplayString((InetSocketAddress)this.httpInterface));
    }

    public void setSimpleResource(String resource, String message, AtomicLong requestCounter) {
        String name = StringUtil.toDisplayString((InetSocketAddress)this.httpInterface);
        this.registry.register(resource, (HttpAsyncRequestHandler)new BasicAsyncRequestHandler((HttpRequestHandler)new RequestCounterHandler(message, name, requestCounter)));
    }

    static {
        HTTP_THREAD_GROUP.setDaemon(false);
        LOGGER = LoggerFactory.getLogger(HttpServer.class);
    }

    private static class RequestCounterHandler
    implements HttpRequestHandler {
        private final String message;
        private final String name;
        private final AtomicLong requestCounter;

        private RequestCounterHandler(String message, String name, AtomicLong requestCounter) {
            this.message = message;
            this.name = name;
            this.requestCounter = requestCounter == null ? new AtomicLong() : requestCounter;
        }

        public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
            long counter = this.requestCounter.incrementAndGet();
            String payload = String.format(this.message, this.name, counter);
            httpResponse.setStatusCode(200);
            httpResponse.setEntity((HttpEntity)new StringEntity(payload));
            LOGGER.debug("{} request handled!", (Object)counter);
        }
    }
}

