/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestDate;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    private static final int KEEP_ALIVE = 5000;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientFactory.class);
    private static AtomicReference<NetworkConfig> config = new AtomicReference();

    private HttpClientFactory() {
    }

    public static NetworkConfig setNetworkConfig(NetworkConfig config) {
        return HttpClientFactory.config.getAndSet(config);
    }

    public static NetworkConfig getNetworkConfig() {
        NetworkConfig config = HttpClientFactory.config.get();
        if (config == null) {
            HttpClientFactory.config.compareAndSet(null, NetworkConfig.getStandard());
            config = HttpClientFactory.config.get();
        }
        return config;
    }

    public static CloseableHttpAsyncClient createClient() {
        return HttpClientFactory.createClient(HttpClientFactory.getNetworkConfig());
    }

    public static CloseableHttpAsyncClient createClient(NetworkConfig config) {
        try {
            CloseableHttpAsyncClient client = HttpAsyncClientBuilder.create().disableCookieManagement().setDefaultRequestConfig(HttpClientFactory.createCustomRequestConfig(config)).setConnectionManager((NHttpClientConnectionManager)HttpClientFactory.createPoolingConnManager()).addInterceptorFirst((HttpRequestInterceptor)new RequestAcceptEncoding()).addInterceptorFirst((HttpRequestInterceptor)new RequestConnControl()).addInterceptorFirst((HttpRequestInterceptor)new RequestDate()).addInterceptorFirst((HttpRequestInterceptor)new RequestExpectContinue(true)).addInterceptorFirst((HttpRequestInterceptor)new RequestTargetHost()).addInterceptorFirst((HttpRequestInterceptor)new RequestUserAgent()).addInterceptorFirst((HttpResponseInterceptor)new ResponseContentEncoding()).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long keepAlive = super.getKeepAliveDuration(response, context);
                    if (keepAlive == -1L) {
                        keepAlive = 5000L;
                    }
                    return keepAlive;
                }
            }).build();
            client.start();
            return client;
        }
        catch (IOReactorException e) {
            LOGGER.error("create http-client failed!", (Throwable)e);
            return null;
        }
    }

    private static RequestConfig createCustomRequestConfig(NetworkConfig config) {
        int connecTimeoutMillis = config.getInt("TCP_CONNECT_TIMEOUT");
        int socketTimeoutSecs = config.getInt("TCP_CONNECTION_IDLE_TIMEOUT");
        return RequestConfig.custom().setConnectionRequestTimeout(connecTimeoutMillis * 4).setConnectTimeout(connecTimeoutMillis).setSocketTimeout(socketTimeoutSecs * 1000).build();
    }

    private static PoolingNHttpClientConnectionManager createPoolingConnManager() throws IOReactorException {
        DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor();
        PoolingNHttpClientConnectionManager cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
        cm.setMaxTotal(250);
        cm.setDefaultMaxPerRoute(50);
        return cm;
    }
}

