/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.proxy2;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.http.message.BasicStatusLine;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.proxy2.HttpTranslator;
import org.eclipse.californium.proxy2.InvalidFieldException;
import org.eclipse.californium.proxy2.TranslationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2CoapTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http2CoapTranslator.class);
    protected final HttpTranslator httpTranslator;

    public Http2CoapTranslator(String mappingPropertiesFileName) {
        this.httpTranslator = new HttpTranslator(mappingPropertiesFileName);
    }

    public Http2CoapTranslator() {
        this.httpTranslator = new HttpTranslator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Request getCoapRequest(HttpRequest httpRequest, String httpResource, boolean proxyingEnabled) throws TranslationException {
        String target;
        if (httpRequest == null) {
            throw new NullPointerException("httpRequest == null");
        }
        if (httpResource == null) {
            throw new NullPointerException("httpResource == null");
        }
        String httpMethod = httpRequest.getRequestLine().getMethod().toLowerCase();
        CoAP.Code code = this.httpTranslator.getCoapCode(httpMethod);
        Request coapRequest = new Request(code, CoAP.Type.CON);
        URI uri = null;
        String uriString = httpRequest.getRequestLine().getUri();
        LOGGER.debug("URI <= '{}'", (Object)uriString);
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            try {
                String encoded = URLEncoder.encode(uriString, "UTF-8");
                uri = new URI(encoded);
                uriString = encoded;
            }
            catch (URISyntaxException ex) {
                LOGGER.debug("Malformed uri", (Throwable)e);
                throw new TranslationException("Malformed uri: " + e.getMessage());
            }
            catch (UnsupportedEncodingException ex) {
                LOGGER.debug("Malformed uri", (Throwable)e);
                throw new TranslationException("Malformed uri: " + e.getMessage());
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Malformed uri", (Throwable)e);
            throw new TranslationException("Malformed uri: " + e.getMessage());
        }
        catch (Throwable e) {
            LOGGER.warn("Malformed uri", e);
            throw new InvalidFieldException("Malformed uri: " + e.getMessage());
        }
        String path = uri.getPath();
        LOGGER.debug("URI path => '{}'", (Object)path);
        if (path.startsWith("/" + httpResource + "/")) {
            int index;
            target = path = path.substring(httpResource.length() + 2);
            if (uri.getQuery() != null) {
                target = path + "?" + uri.getQuery();
            }
            if ((index = target.indexOf(":/")) > 0 && target.charAt(index += 2) != '/') {
                target = target.substring(0, index) + "/" + target.substring(index);
            }
            try {
                uri = new URI(target);
                if (proxyingEnabled) {
                    if (uri.getScheme() == null) {
                        throw new InvalidFieldException("Malformed uri: destination scheme missing! Use http://<proxy-host>/" + httpResource + "/coap://<destination-host>/<path>");
                    }
                    LOGGER.debug("URI destination => '{}'", (Object)target);
                    coapRequest.getOptions().setProxyUri(target);
                }
                if (uri.getScheme() != null) {
                    throw new InvalidFieldException("Malformed uri: local destination doesn't support scheme! Use http://<proxy-host>/" + httpResource + "/<path>");
                }
                target = "coap://localhost/" + target;
                LOGGER.debug("URI local => '{}'", (Object)target);
                coapRequest.setURI(target);
            }
            catch (URISyntaxException e) {
                LOGGER.warn("Malformed destination uri", (Throwable)e);
                throw new InvalidFieldException("Malformed destination uri: " + target + "!");
            }
        } else {
            if (proxyingEnabled && path.equals("/" + httpResource)) {
                target = null;
                if (uri.getQuery() != null) {
                    List query = URLEncodedUtils.parse((String)uri.getQuery(), (Charset)StandardCharsets.UTF_8);
                    for (NameValuePair arg : query) {
                        if (!arg.getName().equalsIgnoreCase("target_uri")) continue;
                        target = arg.getValue();
                        break;
                    }
                }
                if (target == null) {
                    throw new InvalidFieldException("Malformed uri: target_uri is missing! Use http://<proxy-host>/" + httpResource + "?target_uri=coap://<destination-host>/<path>");
                }
                try {
                    uri = new URI(target);
                    if (uri.getScheme() == null) {
                        throw new InvalidFieldException("Malformed uri: destination scheme missing! Use http://<proxy-host>/" + httpResource + "?target_uri=coap://<destination-host>/<path>");
                    }
                    LOGGER.debug("URI destination => '{}'", (Object)target);
                    coapRequest.getOptions().setProxyUri(target);
                }
                catch (URISyntaxException e) {
                    LOGGER.warn("Malformed destination uri", (Throwable)e);
                    throw new InvalidFieldException("Malformed destination uri: " + target + "!");
                }
            }
            if (!proxyingEnabled || uri.getScheme() == null) throw new IllegalArgumentException("URI '" + uriString + "' doesn't match handler '" + httpResource + "'!");
            int index = path.lastIndexOf(47);
            if (0 >= index) throw new TranslationException("Malformed proxy uri: target scheme missing! Use http://<destination-host>/<path>/<target-scheme>:");
            String scheme = path.substring(index + 1);
            if (!scheme.matches("\\w+:$")) throw new TranslationException("Malformed proxy uri: target scheme missing! Use http://<destination-host>/<path>/<target-scheme>:");
            scheme = scheme.substring(0, scheme.length() - 1);
            path = path.substring(0, index);
            try {
                URI destination = new URI(scheme, null, uri.getHost(), uri.getPort(), path, uri.getQuery(), null);
                coapRequest.getOptions().setProxyUri(destination.toASCIIString());
            }
            catch (URISyntaxException e) {
                LOGGER.debug("Malformed proxy uri", (Throwable)e);
                throw new TranslationException("Malformed proxy uri: '" + uriString + "' " + e.getMessage());
            }
        }
        List<Option> coapOptions = this.httpTranslator.getCoapOptions(httpRequest.getAllHeaders());
        for (Option option : coapOptions) {
            coapRequest.getOptions().addOption(option);
        }
        if (!(httpRequest instanceof HttpEntityEnclosingRequest)) return coapRequest;
        HttpEntity httpEntity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
        byte[] payload = this.httpTranslator.getCoapPayload(httpEntity);
        coapRequest.setPayload(payload);
        int coapContentType = this.httpTranslator.getCoapMediaType((HttpMessage)httpRequest);
        coapRequest.getOptions().setContentFormat(coapContentType);
        return coapRequest;
    }

    public void getHttpResponse(HttpRequest httpRequest, Response coapResponse, HttpResponse httpResponse) throws TranslationException {
        if (httpRequest == null) {
            throw new IllegalArgumentException("httpRequest == null");
        }
        if (coapResponse == null) {
            throw new IllegalArgumentException("coapResponse == null");
        }
        if (httpResponse == null) {
            throw new IllegalArgumentException("httpResponse == null");
        }
        CoAP.ResponseCode coapCode = coapResponse.getCode();
        int httpCode = this.httpTranslator.getHttpCode(coapResponse.getCode());
        String reason = EnglishReasonPhraseCatalog.INSTANCE.getReason(httpCode, Locale.ENGLISH);
        BasicStatusLine statusLine = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, httpCode, reason);
        httpResponse.setStatusLine((StatusLine)statusLine);
        Header[] headers = this.httpTranslator.getHttpHeaders(coapResponse.getOptions().asSortedList());
        httpResponse.setHeaders(headers);
        if (!httpResponse.containsHeader("cache-control")) {
            httpResponse.setHeader("cache-control", "max-age=60");
        }
        if (!httpRequest.getRequestLine().getMethod().equalsIgnoreCase("head")) {
            HttpEntity httpEntity;
            if (coapResponse.getOptions().getContentFormat() == -1 && (CoAP.ResponseCode.isClientError((CoAP.ResponseCode)coapCode) || CoAP.ResponseCode.isServerError((CoAP.ResponseCode)coapCode))) {
                LOGGER.info("Set contenttype to TEXT_PLAIN");
                coapResponse.getOptions().setContentFormat(0);
                if (coapResponse.getPayloadSize() == 0) {
                    coapResponse.setPayload(httpCode + ": " + reason);
                }
            }
            if ((httpEntity = this.httpTranslator.getHttpEntity((Message)coapResponse)) != null) {
                httpResponse.setEntity(httpEntity);
                ContentType contentType = ContentType.get((HttpEntity)httpEntity);
                httpResponse.setHeader("content-type", contentType.toString());
            }
        }
    }
}

