/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.osgi;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.server.ServerInterface;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.osgi.EndpointFactory;
import org.eclipse.californium.osgi.ServerEndpointRegistry;
import org.eclipse.californium.osgi.ServerInterfaceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedServer
implements ManagedService,
ServiceTrackerCustomizer<Resource, Resource>,
ServerEndpointRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedServer.class);
    private ServerInterface managedServer;
    private boolean running = false;
    private BundleContext context;
    private ServiceTracker<Resource, Resource> resourceTracker;
    private ServerInterfaceFactory serverFactory;
    private EndpointFactory endpointFactory;

    public ManagedServer(BundleContext bundleContext, EndpointFactory endpointFactory) {
        this(bundleContext, null, endpointFactory);
    }

    public ManagedServer(BundleContext bundleContext, ServerInterfaceFactory serverFactory, EndpointFactory endpointFactory) {
        if (bundleContext == null) {
            throw new NullPointerException("BundleContext must not be null");
        }
        if (endpointFactory == null) {
            throw new NullPointerException("EndpointFactory must not be null");
        }
        this.context = bundleContext;
        this.endpointFactory = endpointFactory;
        this.serverFactory = serverFactory != null ? serverFactory : new ServerInterfaceFactory(){

            @Override
            public ServerInterface newServer(NetworkConfig config) {
                int port = config.getInt("COAP_PORT");
                if (port == 0) {
                    port = 5683;
                }
                return this.newServer(config, port);
            }

            @Override
            public ServerInterface newServer(NetworkConfig config, int ... ports) {
                CoapServer server = new CoapServer(config, ports);
                return server;
            }
        };
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        LOGGER.debug("Updating configuration of managed server instance");
        if (this.isRunning()) {
            this.stop();
        }
        NetworkConfig networkConfig = NetworkConfig.createStandardWithoutFile();
        if (properties != null) {
            Enumeration<String> allKeys = properties.keys();
            while (allKeys.hasMoreElements()) {
                String key = allKeys.nextElement();
                networkConfig.set(key, properties.get(key));
            }
        }
        this.managedServer = this.serverFactory.newServer(networkConfig);
        int securePort = networkConfig.getInt("COAP_SECURE_PORT");
        if (securePort > 0) {
            Endpoint secureEndpoint = this.endpointFactory.getSecureEndpoint(networkConfig, new InetSocketAddress((InetAddress)null, securePort));
            if (secureEndpoint != null) {
                LOGGER.debug("Adding secure endpoint on address {}", (Object)secureEndpoint.getAddress());
                this.managedServer.addEndpoint(secureEndpoint);
            } else {
                LOGGER.warn("Secure endpoint has been configured in server properties but EndpointFactory does not support creation of secure Endpoints");
            }
        }
        this.managedServer.start();
        this.running = true;
        this.resourceTracker = new ServiceTracker(this.context, Resource.class.getName(), (ServiceTrackerCustomizer)this);
        this.resourceTracker.open();
    }

    private boolean isRunning() {
        return this.running;
    }

    public void stop() {
        if (this.managedServer != null) {
            LOGGER.debug("Destroying managed server instance");
            if (this.resourceTracker != null) {
                this.resourceTracker.close();
            }
            this.managedServer.destroy();
            this.running = false;
        }
    }

    public Resource addingService(ServiceReference<Resource> reference) {
        Resource resource = (Resource)this.context.getService(reference);
        LOGGER.debug("Adding resource [{}]", (Object)resource.getName());
        if (resource != null) {
            this.managedServer.add(new Resource[]{resource});
        }
        return resource;
    }

    public void removedService(ServiceReference<Resource> reference, Resource service) {
        LOGGER.debug("Removing resource [{}]", (Object)service.getName());
        this.managedServer.remove(service);
        this.context.ungetService(reference);
    }

    public void modifiedService(ServiceReference<Resource> reference, Resource service) {
    }

    @Override
    public Endpoint getEndpoint(InetSocketAddress address) {
        return this.managedServer.getEndpoint(address);
    }

    @Override
    public Endpoint getEndpoint(int port) {
        return this.managedServer.getEndpoint(port);
    }

    @Override
    public Set<Endpoint> getAllEndpoints() {
        return Collections.unmodifiableSet(new HashSet(this.managedServer.getEndpoints()));
    }
}

