/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.osgi;

import java.net.InetSocketAddress;
import java.util.logging.Logger;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.ConnectorFactory;
import org.eclipse.californium.osgi.EndpointFactory;

public class SimpleServerEndpointFactory
implements EndpointFactory {
    private final Logger log = Logger.getLogger(SimpleServerEndpointFactory.class.getName());
    private ConnectorFactory secureConnectorFactory;

    public SimpleServerEndpointFactory(ConnectorFactory secureConnectorFactory) {
        this.secureConnectorFactory = secureConnectorFactory;
    }

    @Override
    public final Endpoint getEndpoint(NetworkConfig config, InetSocketAddress address) {
        CoapEndpoint endpoint = new CoapEndpoint(address, config);
        return endpoint;
    }

    @Override
    public final Endpoint getSecureEndpoint(NetworkConfig config, InetSocketAddress address) {
        CoapEndpoint endpoint = null;
        if (this.secureConnectorFactory != null) {
            endpoint = new CoapEndpoint(this.secureConnectorFactory.newConnector(address), config);
        } else {
            this.log.fine("A secure ConnectorFactory is required to create secure Endpoints.");
        }
        return endpoint;
    }
}

