/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.interceptors;

import java.util.logging.Logger;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.interceptors.MessageInterceptor;

public class MessageTracer
implements MessageInterceptor {
    private static final Logger LOGGER = Logger.getLogger(MessageTracer.class.getCanonicalName());

    @Override
    public void sendRequest(Request request) {
        LOGGER.info(String.format("%s:%d <== req %s", request.getDestination(), request.getDestinationPort(), request));
    }

    @Override
    public void sendResponse(Response response) {
        LOGGER.info(String.format("%s:%d <== res %s", response.getDestination(), response.getDestinationPort(), response));
    }

    @Override
    public void sendEmptyMessage(EmptyMessage message) {
        LOGGER.info(String.format("%s:%d <== emp %s", message.getDestination(), message.getDestinationPort(), message));
    }

    @Override
    public void receiveRequest(Request request) {
        LOGGER.info(String.format("%s:%d ==> req %s", request.getSource(), request.getSourcePort(), request));
    }

    @Override
    public void receiveResponse(Response response) {
        LOGGER.info(String.format("%s:%d ==> res %s", response.getSource(), response.getSourcePort(), response));
    }

    @Override
    public void receiveEmptyMessage(EmptyMessage message) {
        LOGGER.info(String.format("%s:%d ==> emp %s", message.getSource(), message.getSourcePort(), message));
    }
}

