/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.network.config.NetworkConfigDefaults;
import org.eclipse.californium.core.network.config.NetworkConfigObserver;

public class NetworkConfig {
    private static final Logger LOGGER = Logger.getLogger(NetworkConfig.class.getCanonicalName());
    public static final String DEFAULT = "Californium.properties";
    public static final String DEFAULT_HEADER = "Californium CoAP Properties file";
    private static NetworkConfig standard;
    private Properties properties;
    private List<NetworkConfigObserver> observers = new LinkedList<NetworkConfigObserver>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetworkConfig getStandard() {
        if (standard != null) return standard;
        Class<NetworkConfig> clazz = NetworkConfig.class;
        synchronized (NetworkConfig.class) {
            if (standard != null) return standard;
            NetworkConfig.createStandardWithFile(new File(DEFAULT));
            // ** MonitorExit[var0] (shouldn't be in output)
            return standard;
        }
    }

    public static void setStandard(NetworkConfig standard) {
        NetworkConfig.standard = standard;
    }

    public static NetworkConfig createStandardWithoutFile() {
        LOGGER.info("Creating standard network configuration properties without a file");
        standard = new NetworkConfig();
        return standard;
    }

    public static NetworkConfig createStandardWithFile(File file) {
        standard = new NetworkConfig();
        if (file.exists()) {
            LOGGER.info("Loading standard properties from file " + file);
            try {
                standard.load(file);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error while loading properties from " + file.getAbsolutePath(), e);
            }
        } else {
            LOGGER.info("Storing standard properties in file " + file);
            try {
                standard.store(file);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error while storing properties to " + file.getAbsolutePath(), e);
            }
        }
        return standard;
    }

    public NetworkConfig() {
        this.properties = new Properties();
        NetworkConfigDefaults.setDefaults(this);
    }

    public void load(File file) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        this.properties.load(inStream);
    }

    public void store(File file) throws IOException {
        this.store(file, DEFAULT_HEADER);
    }

    public void store(File file, String header) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        this.properties.store(new FileWriter(file), header);
    }

    public String getString(String key) {
        return this.properties.getProperty(key);
    }

    public int getInt(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Could not convert property \"" + key + "\" with value \"" + value + "\" to integer", e);
            }
        } else {
            LOGGER.warning("Property \"" + key + "\" is undefined");
        }
        return 0;
    }

    public long getLong(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Could not convert property \"" + key + "\" with value \"" + value + "\" to long", e);
                return 0L;
            }
        }
        LOGGER.warning("Property \"" + key + "\" is undefined");
        return 0L;
    }

    public float getFloat(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Could not convert property \"" + key + "\" with value \"" + value + "\" to float", e);
                return 0.0f;
            }
        }
        LOGGER.warning("Property \"" + key + "\" is undefined");
        return 0.0f;
    }

    public double getDouble(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Could not convert property \"" + key + "\" with value \"" + value + "\" to double", e);
                return 0.0;
            }
        }
        LOGGER.warning("Property \"" + key + "\" is undefined");
        return 0.0;
    }

    public boolean getBoolean(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Could not convert property \"" + key + "\" with value \"" + value + "\" to boolean", e);
                return false;
            }
        }
        LOGGER.warning("Property \"" + key + "\" is undefined");
        return false;
    }

    public NetworkConfig set(String key, Object value) {
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig setString(String key, String value) {
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig setInt(String key, int value) {
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig setLong(String key, long value) {
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig setFloat(String key, float value) {
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig setDouble(String key, double value) {
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig setBoolean(String key, boolean value) {
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig addConfigObserver(NetworkConfigObserver observer) {
        this.observers.add(observer);
        return this;
    }

    public NetworkConfig removeConfigObserver(NetworkConfigObserver observer) {
        this.observers.remove(observer);
        return this;
    }

    public class Keys {
        public static final String COAP_PORT = "COAP_PORT";
        public static final String COAP_SECURE_PORT = "COAP_SECURE_PORT";
        public static final String ACK_TIMEOUT = "ACK_TIMEOUT";
        public static final String ACK_RANDOM_FACTOR = "ACK_RANDOM_FACTOR";
        public static final String ACK_TIMEOUT_SCALE = "ACK_TIMEOUT_SCALE";
        public static final String MAX_RETRANSMIT = "MAX_RETRANSMIT";
        public static final String EXCHANGE_LIFETIME = "EXCHANGE_LIFETIME";
        public static final String NON_LIFETIME = "NON_LIFETIME";
        public static final String MAX_TRANSMIT_WAIT = "MAX_TRANSMIT_WAIT";
        public static final String NSTART = "NSTART";
        public static final String LEISURE = "LEISURE";
        public static final String PROBING_RATE = "PROBING_RATE";
        public static final String USE_RANDOM_MID_START = "USE_RANDOM_MID_START";
        public static final String TOKEN_SIZE_LIMIT = "TOKEN_SIZE_LIMIT";
        public static final String PREFERRED_BLOCK_SIZE = "PREFERRED_BLOCK_SIZE";
        public static final String MAX_MESSAGE_SIZE = "MAX_MESSAGE_SIZE";
        public static final String BLOCKWISE_STATUS_LIFETIME = "BLOCKWISE_STATUS_LIFETIME";
        public static final String NOTIFICATION_CHECK_INTERVAL_TIME = "NOTIFICATION_CHECK_INTERVAL";
        public static final String NOTIFICATION_CHECK_INTERVAL_COUNT = "NOTIFICATION_CHECK_INTERVAL_COUNT";
        public static final String NOTIFICATION_REREGISTRATION_BACKOFF = "NOTIFICATION_REREGISTRATION_BACKOFF";
        public static final String USE_CONGESTION_CONTROL = "USE_CONGESTION_CONTROL";
        public static final String CONGESTION_CONTROL_ALGORITHM = "CONGESTION_CONTROL_ALGORITHM";
        public static final String PROTOCOL_STAGE_THREAD_COUNT = "PROTOCOL_STAGE_THREAD_COUNT";
        public static final String NETWORK_STAGE_RECEIVER_THREAD_COUNT = "NETWORK_STAGE_RECEIVER_THREAD_COUNT";
        public static final String NETWORK_STAGE_SENDER_THREAD_COUNT = "NETWORK_STAGE_SENDER_THREAD_COUNT";
        public static final String UDP_CONNECTOR_DATAGRAM_SIZE = "UDP_CONNECTOR_DATAGRAM_SIZE";
        public static final String UDP_CONNECTOR_RECEIVE_BUFFER = "UDP_CONNECTOR_RECEIVE_BUFFER";
        public static final String UDP_CONNECTOR_SEND_BUFFER = "UDP_CONNECTOR_SEND_BUFFER";
        public static final String UDP_CONNECTOR_OUT_CAPACITY = "UDP_CONNECTOR_OUT_CAPACITY";
        public static final String DEDUPLICATOR = "DEDUPLICATOR";
        public static final String DEDUPLICATOR_MARK_AND_SWEEP = "DEDUPLICATOR_MARK_AND_SWEEP";
        public static final String MARK_AND_SWEEP_INTERVAL = "MARK_AND_SWEEP_INTERVAL";
        public static final String DEDUPLICATOR_CROP_ROTATION = "DEDUPLICATOR_CROP_ROTATION";
        public static final String CROP_ROTATION_PERIOD = "CROP_ROTATION_PERIOD";
        public static final String NO_DEDUPLICATOR = "NO_DEDUPLICATOR";
        public static final String HTTP_PORT = "HTTP_PORT";
        public static final String HTTP_SERVER_SOCKET_TIMEOUT = "HTTP_SERVER_SOCKET_TIMEOUT";
        public static final String HTTP_SERVER_SOCKET_BUFFER_SIZE = "HTTP_SERVER_SOCKET_BUFFER_SIZE";
        public static final String HTTP_CACHE_RESPONSE_MAX_AGE = "HTTP_CACHE_RESPONSE_MAX_AGE";
        public static final String HTTP_CACHE_SIZE = "HTTP_CACHE_SIZE";
        public static final String HEALTH_STATUS_PRINT_LEVEL = "HEALTH_STATUS_PRINT_LEVEL";
        public static final String HEALTH_STATUS_INTERVAL = "HEALTH_STATUS_INTERVAL";
    }
}

