/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.observe.ObserveNotificationOrderer;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.core.observe.ObserveRelationContainer;
import org.eclipse.californium.core.observe.ObserveRelationFilter;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.core.server.resources.ResourceAttributes;
import org.eclipse.californium.core.server.resources.ResourceObserver;

public class CoapResource
implements Resource {
    protected static final Logger LOGGER = Logger.getLogger(CoapResource.class.getCanonicalName());
    private final ResourceAttributes attributes;
    private String name;
    private String path;
    private boolean visible;
    private boolean observable;
    private ConcurrentHashMap<String, Resource> children;
    private Resource parent;
    private CoAP.Type observeType = null;
    private List<ResourceObserver> observers;
    private ObserveRelationContainer observeRelations;
    private ObserveNotificationOrderer notificationOrderer;

    public CoapResource(String name) {
        this(name, true);
    }

    public CoapResource(String name, boolean visible) {
        this.name = name;
        this.path = "";
        this.visible = visible;
        this.attributes = new ResourceAttributes();
        this.children = new ConcurrentHashMap();
        this.observers = new CopyOnWriteArrayList<ResourceObserver>();
        this.observeRelations = new ObserveRelationContainer();
        this.notificationOrderer = new ObserveNotificationOrderer();
    }

    @Override
    public void handleRequest(Exchange exchange) {
        CoAP.Code code = exchange.getRequest().getCode();
        switch (code) {
            case GET: {
                this.handleGET(new CoapExchange(exchange, this));
                break;
            }
            case POST: {
                this.handlePOST(new CoapExchange(exchange, this));
                break;
            }
            case PUT: {
                this.handlePUT(new CoapExchange(exchange, this));
                break;
            }
            case DELETE: {
                this.handleDELETE(new CoapExchange(exchange, this));
            }
        }
    }

    public void handleGET(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
    }

    public void handlePOST(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
    }

    public void handlePUT(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
    }

    public void handleDELETE(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
    }

    public void checkObserveRelation(Exchange exchange, Response response) {
        ObserveRelation relation = exchange.getRelation();
        if (relation == null) {
            return;
        }
        if (CoAP.ResponseCode.isSuccess(response.getCode())) {
            response.getOptions().setObserve(this.notificationOrderer.getCurrent());
            if (!relation.isEstablished()) {
                relation.setEstablished(true);
                this.addObserveRelation(relation);
            } else if (this.observeType != null) {
                response.setType(this.observeType);
            }
        }
    }

    public CoapClient createClient() {
        CoapClient client = new CoapClient();
        client.setExecutor(this.getExecutor());
        List<Endpoint> endpoints = this.getEndpoints();
        if (!endpoints.isEmpty()) {
            client.setEndpoint(endpoints.get(0));
        }
        return client;
    }

    public CoapClient createClient(URI uri) {
        return this.createClient().setURI(uri.toString());
    }

    public CoapClient createClient(String uri) {
        return this.createClient().setURI(uri);
    }

    @Override
    public synchronized void add(Resource child) {
        if (child.getName() == null) {
            throw new NullPointerException("Child must have a name");
        }
        if (child.getParent() != null) {
            child.getParent().delete(child);
        }
        this.children.put(child.getName(), child);
        child.setParent(this);
        for (ResourceObserver obs : this.observers) {
            obs.addedChild(child);
        }
    }

    public synchronized CoapResource add(CoapResource child) {
        this.add((Resource)child);
        return this;
    }

    public synchronized CoapResource add(CoapResource ... children) {
        for (CoapResource child : children) {
            this.add(child);
        }
        return this;
    }

    @Override
    public synchronized boolean delete(Resource child) {
        Resource deleted = this.delete(child.getName());
        if (deleted == child) {
            child.setParent(null);
            child.setPath(null);
            for (ResourceObserver obs : this.observers) {
                obs.removedChild(child);
            }
            return true;
        }
        return false;
    }

    public synchronized Resource delete(String name) {
        return this.children.remove(name);
    }

    public synchronized void delete() {
        Resource parent = this.getParent();
        if (parent != null) {
            parent.delete(this);
        }
        if (this.isObservable()) {
            this.clearAndNotifyObserveRelations(CoAP.ResponseCode.NOT_FOUND);
        }
    }

    public void clearAndNotifyObserveRelations(CoAP.ResponseCode code) {
        for (ObserveRelation relation : this.observeRelations) {
            relation.cancel();
            relation.getExchange().sendResponse(new Response(code));
        }
    }

    public void clearObserveRelations() {
        for (ObserveRelation relation : this.observeRelations) {
            relation.cancel();
        }
    }

    @Override
    public Resource getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Resource parent) {
        this.parent = parent;
        if (parent != null) {
            this.path = parent.getPath() + parent.getName() + "/";
        }
        this.adjustChildrenPath();
    }

    @Override
    public Resource getChild(String name) {
        return this.children.get(name);
    }

    @Override
    public synchronized void addObserver(ResourceObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public synchronized void removeObserver(ResourceObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public ResourceAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getURI() {
        return this.getPath() + this.getName();
    }

    @Override
    public synchronized void setPath(String path) {
        String old = this.path;
        this.path = path;
        for (ResourceObserver obs : this.observers) {
            obs.changedPath(old);
        }
        this.adjustChildrenPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        String old = this.name;
        Resource parent = this.getParent();
        if (parent != null) {
            Resource resource = parent;
            synchronized (resource) {
                parent.delete(this);
                this.name = name;
                parent.add(this);
            }
        } else {
            this.name = name;
        }
        this.adjustChildrenPath();
        for (ResourceObserver obs : this.observers) {
            obs.changedName(old);
        }
    }

    private void adjustChildrenPath() {
        String childpath = this.path + this.name + "/";
        for (Resource child : this.children.values()) {
            child.setPath(childpath);
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isObservable() {
        return this.observable;
    }

    public void setObservable(boolean observable) {
        this.observable = observable;
    }

    public void setObserveType(CoAP.Type type) {
        if (type == CoAP.Type.ACK || type == CoAP.Type.RST) {
            throw new IllegalArgumentException("Only CON and NON notifications are allowed or null for no changes by the framework");
        }
        this.observeType = type;
    }

    @Override
    public void addObserveRelation(ObserveRelation relation) {
        if (this.observeRelations.add(relation)) {
            LOGGER.info("Replacing observe relation between " + relation.getKey() + " and resource " + this.getURI());
        } else {
            LOGGER.info("Successfully established observe relation between " + relation.getKey() + " and resource " + this.getURI());
        }
        for (ResourceObserver obs : this.observers) {
            obs.addedObserveRelation(relation);
        }
    }

    @Override
    public void removeObserveRelation(ObserveRelation relation) {
        this.observeRelations.remove(relation);
        for (ResourceObserver obs : this.observers) {
            obs.removedObserveRelation(relation);
        }
    }

    public int getObserverCount() {
        return this.observeRelations.getSize();
    }

    public void changed() {
        this.changed(null);
    }

    public void changed(final ObserveRelationFilter filter) {
        ExecutorService executor = this.getExecutor();
        if (executor == null) {
            this.notifyObserverRelations(filter);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    CoapResource.this.notifyObserverRelations(filter);
                }
            });
        }
    }

    protected void notifyObserverRelations(ObserveRelationFilter filter) {
        this.notificationOrderer.getNextObserveNumber();
        for (ObserveRelation relation : this.observeRelations) {
            if (null != filter && !filter.accept(relation)) continue;
            relation.notifyObservers();
        }
    }

    @Override
    public Collection<Resource> getChildren() {
        return this.children.values();
    }

    @Override
    public ExecutorService getExecutor() {
        return this.parent != null ? this.parent.getExecutor() : null;
    }

    public void execute(Runnable task) {
        ExecutorService executor = this.getExecutor();
        if (executor == null) {
            task.run();
        } else {
            executor.execute(task);
        }
    }

    public void executeAndWait(final Runnable task) throws InterruptedException {
        final Semaphore semaphore = new Semaphore(0);
        this.execute(new Runnable(){

            @Override
            public void run() {
                task.run();
                semaphore.release();
            }
        });
        semaphore.acquire();
    }

    @Override
    public List<Endpoint> getEndpoints() {
        if (this.parent == null) {
            return Collections.emptyList();
        }
        return this.parent.getEndpoints();
    }
}

