/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabCornerHeaderRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabGrandTotalRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabHeaderRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabMeasureHeaderRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;

public class CrosstabHeaderExecutor
extends BaseCrosstabExecutor {
    private static final Logger logger = Logger.getLogger(CrosstabHeaderExecutor.class.getName());
    private boolean hasMeasureHeader;
    private boolean useCornerHeader;
    private boolean hasGrandTotal;
    private int currentGroupIndex;
    private int currentGrandTotalRow;
    private int totalGrandTotalRow;
    private long resetRowCursorPosition = -1L;

    public CrosstabHeaderExecutor(BaseCrosstabExecutor parent) {
        super(parent);
    }

    @Override
    public IContent execute() {
        ITableBandContent content = this.context.getReportContent().createTableBandContent();
        content.setBandType(1);
        this.initializeContent(content, null);
        this.prepareChildren();
        return content;
    }

    @Override
    public void close() {
        try {
            EdgeCursor rowCursor = this.getRowEdgeCursor();
            if (rowCursor != null && this.resetRowCursorPosition != -1L) {
                rowCursor.setPosition(this.resetRowCursorPosition);
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabHeaderExecutor.error.reset.row.position"), e);
        }
        this.resetRowCursorPosition = -1L;
        super.close();
    }

    private void prepareChildren() {
        try {
            EdgeCursor rowCursor = this.getRowEdgeCursor();
            if (rowCursor != null) {
                this.resetRowCursorPosition = rowCursor.getPosition();
                rowCursor.setPosition(-1L);
            }
            this.hasGrandTotal = this.needRowGrandTotal("before");
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabHeaderExecutor.error.reset.row.position"), e);
        }
        this.currentGroupIndex = 0;
        this.hasMeasureHeader = GroupUtil.hasMeasureHeader(this.crosstabItem, 1);
        boolean bl = this.useCornerHeader = this.columnGroups.size() == 0 && !this.hasMeasureHeader && this.crosstabItem.getHeader() != null;
        if (this.hasGrandTotal) {
            this.currentGrandTotalRow = 0;
            int count = this.crosstabItem.getMeasureCount();
            this.totalGrandTotalRow = count > 1 && "vertical".equals(this.crosstabItem.getMeasureDirection()) ? count : 1;
        }
    }

    @Override
    public IReportItemExecutor getNextChild() {
        BaseCrosstabExecutor nextExecutor = null;
        if (this.currentGroupIndex < this.columnGroups.size()) {
            EdgeGroup eg = (EdgeGroup)this.columnGroups.get(this.currentGroupIndex++);
            DimensionViewHandle dv = this.crosstabItem.getDimension(1, eg.dimensionIndex);
            LevelViewHandle lv = dv.getLevel(eg.levelIndex);
            nextExecutor = new CrosstabHeaderRowExecutor(this, lv);
        } else if (this.hasMeasureHeader) {
            nextExecutor = new CrosstabMeasureHeaderRowExecutor(this);
            this.hasMeasureHeader = false;
        } else if (this.useCornerHeader) {
            nextExecutor = new CrosstabCornerHeaderRowExecutor(this);
            this.useCornerHeader = false;
        } else if (this.hasGrandTotal) {
            return new CrosstabGrandTotalRowExecutor(this, this.currentGrandTotalRow++);
        }
        return nextExecutor;
    }

    @Override
    public boolean hasNextChild() {
        if (this.currentGroupIndex < this.columnGroups.size()) {
            return true;
        }
        if (this.hasMeasureHeader) {
            return true;
        }
        if (this.useCornerHeader) {
            return true;
        }
        if (this.hasGrandTotal && this.currentGrandTotalRow < this.totalGrandTotalRow) {
            if (GroupUtil.hasTotalContent(this.crosstabItem, 0, -1, -1, "vertical".equals(this.crosstabItem.getMeasureDirection()) ? this.currentGrandTotalRow : -1)) {
                return true;
            }
            ++this.currentGrandTotalRow;
            return this.hasNextChild();
        }
        return false;
    }
}

