/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IPageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.content.impl.BookmarkContent;
import org.eclipse.birt.report.engine.emitter.CompositeContentEmitter;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.EngineEmitterServices;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ContextPageBreakHandler;
import org.eclipse.birt.report.engine.executor.EngineExtensionManager;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.OnPageBreakLayoutPageHandle;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.extension.engine.IContentProcessor;
import org.eclipse.birt.report.engine.extension.engine.IDocumentExtension;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.IPageHintWriter;
import org.eclipse.birt.report.engine.internal.document.IReportContentWriter;
import org.eclipse.birt.report.engine.internal.document.v3.ReportContentWriterV3;
import org.eclipse.birt.report.engine.internal.document.v4.FixedLayoutPageHintWriter;
import org.eclipse.birt.report.engine.internal.document.v4.PageHintWriterV4;
import org.eclipse.birt.report.engine.internal.presentation.ReportDocumentInfo;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.layout.CompositeLayoutPageHandler;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.LayoutEngineFactory;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.HTMLReportLayoutEngine;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.LayoutEngine;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ITemplateArea;
import org.eclipse.birt.report.engine.nLayout.area.ITextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.SizeBasedContent;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;
import org.eclipse.birt.report.engine.presentation.PageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.presentation.SizeBasedPageSection;
import org.eclipse.birt.report.engine.util.ContentUtil;

public class ReportDocumentBuilder {
    protected static Logger logger = Logger.getLogger(ReportDocumentBuilder.class.getName());
    protected ExecutionContext executionContext;
    protected long pageNumber;
    protected ReportDocumentWriter document;
    protected CompositeContentEmitter contentEmitter;
    protected CompositeContentEmitter outputEmitters;
    protected IPageHintWriter pageHintWriter;
    protected IPageHandler pageHandler;
    protected IReportLayoutEngine engine;
    protected CompositeLayoutPageHandler layoutPageHandler;

    public ReportDocumentBuilder(ExecutionContext context, ReportDocumentWriter document) throws EngineException {
        this.executionContext = context;
        this.document = document;
        OnPageBreakLayoutPageHandle onPageBreakHandler = new OnPageBreakLayoutPageHandle(context);
        this.outputEmitters = new CompositeContentEmitter();
        this.outputEmitters.addEmitter(new PageEmitter());
        this.outputEmitters.addEmitter(onPageBreakHandler.getEmitter());
        this.layoutPageHandler = new CompositeLayoutPageHandler();
        this.layoutPageHandler.addPageHandler(onPageBreakHandler);
        if (this.executionContext.isFixedLayout()) {
            this.layoutPageHandler.addPageHandler(new FixedLayoutPageHandler());
        } else {
            this.layoutPageHandler.addPageHandler(new AutoLayoutPageHandler());
        }
        this.layoutPageHandler.addPageHandler(new ContextPageBreakHandler(this.executionContext));
        this.contentEmitter = new CompositeContentEmitter();
        this.contentEmitter.addEmitter(new ContentEmitter());
        String[] exts = context.getEngineExtensions();
        if (exts != null) {
            String[] stringArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                String extName = stringArray[n2];
                EngineExtensionManager extManager = context.getEngineExtensionManager();
                IDocumentExtension docExt = extManager.getDocumentExtension(extName);
                if (docExt != null) {
                    IContentProcessor pageProc;
                    IContentProcessor contProc = docExt.getContentProcessor();
                    if (contProc != null) {
                        this.contentEmitter.addEmitter(new ProcessorEmitter(contProc));
                    }
                    if ((pageProc = docExt.getPageProcessor()) != null) {
                        this.outputEmitters.addEmitter(new ProcessorEmitter(pageProc));
                    }
                }
                ++n2;
            }
        }
    }

    public IContentEmitter getContentEmitter() {
        return this.contentEmitter;
    }

    public void build() throws BirtException {
        IReportExecutor executor = this.executionContext.getExecutor();
        this.engine = LayoutEngineFactory.createLayoutEngine("page-break-pagination");
        this.engine.setOption("task_type", 1);
        IReportContent report = executor.execute();
        if (this.executionContext.isFixedLayout() && this.engine instanceof HTMLReportLayoutEngine) {
            HTMLLayoutContext htmlContext = ((HTMLReportLayoutEngine)this.engine).getContext();
            htmlContext.setFixedLayout(true);
            LayoutEngine pdfEmitter = new LayoutEngine(htmlContext, this.outputEmitters, null, this.executionContext, 0L);
            pdfEmitter.setPageHandler(this.layoutPageHandler);
            this.initializeContentEmitter(pdfEmitter, executor);
            pdfEmitter.createPageHintGenerator();
            pdfEmitter.start(report);
            this.engine.layout(executor, report, pdfEmitter, true);
            this.engine.close();
            pdfEmitter.end(report);
        } else {
            this.engine.setPageHandler(this.layoutPageHandler);
            this.outputEmitters.start(report);
            this.engine.layout(executor, report, this.outputEmitters, true);
            this.engine.close();
            this.outputEmitters.end(report);
        }
        this.engine = null;
    }

    protected void initializeContentEmitter(IContentEmitter emitter, IReportExecutor executor) throws BirtException {
        IReportContext reportContext = this.executionContext.getReportContext();
        IRenderOption options = this.executionContext.getRenderOption();
        EngineEmitterServices services = new EngineEmitterServices(reportContext, options, null);
        emitter.initialize(services);
    }

    public void cancel() {
        if (this.engine != null) {
            this.engine.cancel();
        }
    }

    public void setPageHandler(IPageHandler handler) {
        this.pageHandler = handler;
    }

    protected void ensureContentSaved(IReportContentWriter writer, IContent content) throws IOException {
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        if (docExt == null) {
            IContent parent = (IContent)content.getParent();
            if (parent != null && parent != parent.getReportContent().getRoot()) {
                this.ensureContentSaved(writer, parent);
            }
            writer.writeContent(content);
        }
    }

    long writeContent(IReportContentWriter writer, IContent content) throws IOException {
        IContent parent = (IContent)content.getParent();
        if (parent != null && parent != parent.getReportContent().getRoot()) {
            this.ensureContentSaved(writer, parent);
        }
        return writer.writeContent(content);
    }

    private boolean needSave(IContent content) {
        InstanceID id = content.getInstanceID();
        if (id == null || id.getComponentID() == -1L) {
            return true;
        }
        IContent parent = (IContent)content.getParent();
        if (parent != null) {
            InstanceID pid = parent.getInstanceID();
            if (pid == null || pid.getComponentID() == -1L) {
                return true;
            }
            if (parent.getGenerateBy() instanceof ExtendedItemDesign) {
                return true;
            }
        }
        if (content instanceof AbstractContent) {
            return ((AbstractContent)content).needSave();
        }
        return true;
    }

    class AutoLayoutPageHandler
    implements ILayoutPageHandler {
        IPageHintWriter hintWriter;

        AutoLayoutPageHandler() {
        }

        protected boolean ensureOpen() {
            if (this.hintWriter != null) {
                return true;
            }
            try {
                this.hintWriter = new PageHintWriterV4(ReportDocumentBuilder.this.document.getArchive());
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Can not open the hint stream", ex);
                return false;
            }
            return true;
        }

        protected void close() {
            if (this.hintWriter != null) {
                this.hintWriter.close();
            }
            this.hintWriter = null;
        }

        protected void writeTotalPage(long pageNumber) {
            if (this.ensureOpen()) {
                try {
                    this.hintWriter.writeTotalPage(pageNumber);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Failed to save the page number", ex);
                    this.close();
                }
            }
        }

        void writePageVariables() {
            if (this.ensureOpen()) {
                try {
                    Collection<PageVariable> vars = this.getReportVariable();
                    this.hintWriter.writePageVariables(vars);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Failed to save the page variables", ex);
                    this.close();
                }
            }
        }

        void writePageHint(PageHint pageHint) {
            if (this.ensureOpen()) {
                try {
                    this.hintWriter.writePageHint(pageHint);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Failed to save the page hint", ex);
                    this.close();
                }
            }
        }

        private long getContentIndex(IContent content) {
            DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
            if (docExt != null) {
                long offset = docExt.getIndex();
                if (offset != -1L) {
                    return offset;
                }
                return docExt.getPrevious();
            }
            return -1L;
        }

        protected InstanceIndex[] createInstanceIndexes(IContent content) {
            LinkedList<InstanceIndex> indexes = new LinkedList<InstanceIndex>();
            while (content != null && content != content.getReportContent().getRoot()) {
                InstanceID id = content.getInstanceID();
                long offset = this.getContentIndex(content);
                indexes.addFirst(new InstanceIndex(id, offset));
                content = (IContent)content.getParent();
            }
            return indexes.toArray(new InstanceIndex[0]);
        }

        private PageSection createPageSection(IContent start, IContent end) {
            PageSection section = new PageSection();
            section.starts = this.createInstanceIndexes(start);
            section.ends = this.createInstanceIndexes(end);
            return section;
        }

        private Collection<PageVariable> getReportVariable() {
            ArrayList<PageVariable> reportVars = new ArrayList<PageVariable>();
            Collection<PageVariable> vars = ReportDocumentBuilder.this.executionContext.getPageVariables();
            for (PageVariable var : vars) {
                if (!"report".equals(var.getScope())) continue;
                reportVars.add(var);
            }
            return reportVars;
        }

        protected Collection<PageVariable> getPageVariable() {
            ArrayList<PageVariable> pageVars = new ArrayList<PageVariable>();
            Collection<PageVariable> vars = ReportDocumentBuilder.this.executionContext.getPageVariables();
            for (PageVariable var : vars) {
                if (!"page".equals(var.getScope())) continue;
                pageVars.add(var);
            }
            return pageVars;
        }

        @Override
        public void onPage(long pageNumber, Object context) {
            if (context instanceof HTMLLayoutContext) {
                HTMLLayoutContext htmlContext = (HTMLLayoutContext)context;
                ReportDocumentBuilder.this.document.setPageCount(pageNumber);
                boolean reportFinished = htmlContext.isFinished();
                if (reportFinished) {
                    this.writePageVariables();
                    this.writeTotalPage(pageNumber);
                    this.close();
                    return;
                }
                boolean checkpoint = false;
                if (ReportDocumentBuilder.this.executionContext.isProgressiveViewingEnable() && (pageNumber == 1L || pageNumber == 10L || pageNumber == 50L || pageNumber % 100L == 0L)) {
                    checkpoint = true;
                }
                ArrayList pageHint = htmlContext.getPageHintManager().getPageHint();
                PageHint hint = new PageHint(pageNumber, htmlContext.getMasterPage());
                int i = 0;
                while (i < pageHint.size()) {
                    IContent[] range = (IContent[])pageHint.get(i);
                    PageSection section = this.createPageSection(range[0], range[1]);
                    hint.addSection(section);
                    ++i;
                }
                hint.addUnresolvedRowHints(htmlContext.getPageHintManager().getUnresolvedRowHints().values());
                hint.addTableColumnHints(htmlContext.getPageHintManager().getTableColumnHints());
                Collection<PageVariable> vars = this.getPageVariable();
                hint.getPageVariables().addAll(vars);
                this.writePageHint(hint);
                if (checkpoint) {
                    try {
                        IDocArchiveWriter archive = ReportDocumentBuilder.this.document.getArchive();
                        this.writeTotalPage(pageNumber);
                        ReportDocumentBuilder.this.document.savePersistentObjects(ReportDocumentBuilder.this.executionContext.getGlobalBeans());
                        ReportDocumentBuilder.this.document.saveCoreStreams();
                        archive.flush();
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, " check point failed ", e);
                    }
                }
                if (ReportDocumentBuilder.this.pageHandler != null && !htmlContext.getCancelFlag()) {
                    ReportDocumentInfo docInfo = new ReportDocumentInfo(ReportDocumentBuilder.this.executionContext, pageNumber, false);
                    ReportDocumentBuilder.this.pageHandler.onPage((int)pageNumber, checkpoint, docInfo);
                }
            }
            ReportDocumentBuilder.this.executionContext.getProgressMonitor().onProgress(4, (int)pageNumber);
        }
    }

    class ContentEmitter
    extends ContentEmitterAdapter {
        ReportContentWriterV3 writer;
        ReportContentWriterV3 pageWriter;
        RAOutputStream indexStream;
        HashSet<String> savedMasterPages = new HashSet();
        private boolean inMasterPage;
        private boolean writePage;

        ContentEmitter() {
        }

        protected void open(IReportContent report) {
            try {
                this.writer = new ReportContentWriterV3(ReportDocumentBuilder.this.document.getArchive(), "/content/content.dat");
                this.writer.writeReport(report);
                this.pageWriter = new ReportContentWriterV3(ReportDocumentBuilder.this.document.getArchive(), "/content/page.dat");
                this.indexStream = ReportDocumentBuilder.this.document.getArchive().createRandomAccessStream("/content/page.idx");
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "failed to open the content writers", ex);
                this.close();
            }
        }

        protected void close() {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
            if (this.pageWriter != null) {
                this.pageWriter.close();
                this.pageWriter = null;
            }
            if (this.indexStream != null) {
                try {
                    this.indexStream.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "failed to close the index stream", ex);
                }
                this.indexStream = null;
            }
        }

        @Override
        public void start(IReportContent report) {
            this.open(report);
        }

        @Override
        public void end(IReportContent report) {
            this.close();
        }

        @Override
        public void startPage(IPageContent page) {
            this.inMasterPage = true;
            String masterPageName = null;
            Object generateBy = page.getGenerateBy();
            if (generateBy != null && generateBy instanceof MasterPageDesign) {
                masterPageName = ((MasterPageDesign)generateBy).getName();
            }
            if (!this.savedMasterPages.contains(masterPageName)) {
                this.writePage = true;
                try {
                    long pageOffset = ReportDocumentBuilder.this.writeContent(this.pageWriter, page);
                    ByteArrayOutputStream writeBuffer = new ByteArrayOutputStream(128);
                    DataOutputStream indexBuffer = new DataOutputStream(writeBuffer);
                    IOUtil.writeString(indexBuffer, masterPageName);
                    IOUtil.writeLong(indexBuffer, pageOffset);
                    this.indexStream.write(writeBuffer.toByteArray());
                    this.savedMasterPages.add(masterPageName);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "write page content failed", ex);
                    this.close();
                }
            }
        }

        @Override
        public void endPage(IPageContent pageContent) {
            this.inMasterPage = false;
            this.writePage = false;
        }

        @Override
        public void startContent(IContent content) {
            if (this.inMasterPage) {
                if (this.writePage && this.pageWriter != null) {
                    if (!ReportDocumentBuilder.this.needSave(content)) {
                        return;
                    }
                    try {
                        ReportDocumentBuilder.this.writeContent(this.pageWriter, content);
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, "Write content error", ex);
                        this.close();
                    }
                }
                return;
            }
            if (this.writer != null) {
                if (!ReportDocumentBuilder.this.needSave(content)) {
                    return;
                }
                try {
                    String bookmark;
                    InstanceID iid;
                    long offset = ReportDocumentBuilder.this.writeContent(this.writer, content);
                    Object generateBy = content.getGenerateBy();
                    if ((generateBy instanceof TableItemDesign || generateBy instanceof ListItemDesign || generateBy instanceof ExtendedItemDesign) && (iid = content.getInstanceID()) != null) {
                        String strIID = iid.toUniqueString();
                        ReportDocumentBuilder.this.document.setOffsetOfInstance(strIID, offset);
                    }
                    if ((bookmark = content.getBookmark()) != null) {
                        ReportDocumentBuilder.this.document.setOffsetOfBookmark(bookmark, offset);
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Write content error", ex);
                    this.close();
                }
            }
        }
    }

    class FixedLayoutPageHandler
    extends AutoLayoutPageHandler
    implements ILayoutPageHandler {
        FixedLayoutPageHandler() {
        }

        @Override
        protected boolean ensureOpen() {
            if (this.hintWriter != null) {
                return true;
            }
            try {
                this.hintWriter = new FixedLayoutPageHintWriter(ReportDocumentBuilder.this.document.getArchive());
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Can not open the hint stream", ex);
                return false;
            }
            return true;
        }

        protected void writePageHint(LayoutContext pdfContext) {
            ArrayList pageHintList = pdfContext.getPageHint();
            PageHint hint = new PageHint(pdfContext.getPageNumber(), pdfContext.getMasterPage());
            int i = 0;
            while (i < pageHintList.size()) {
                SizeBasedContent[] range = (SizeBasedContent[])pageHintList.get(i);
                SizeBasedPageSection section = this.createPageSection(range[0], range[1]);
                hint.addSection(section);
                ++i;
            }
            hint.addUnresolvedRowHints(pdfContext.getUnresolvedRowHints());
            hint.addTableColumnHints(pdfContext.getTableColumnHints());
            Collection<PageVariable> vars = this.getPageVariable();
            hint.getPageVariables().addAll(vars);
            if (this.ensureOpen()) {
                try {
                    this.hintWriter.writePageHint(hint);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Failed to save the page hint", ex);
                    this.close();
                }
            }
        }

        private SizeBasedPageSection createPageSection(SizeBasedContent start, SizeBasedContent end) {
            SizeBasedPageSection section = new SizeBasedPageSection();
            section.starts = this.createInstanceIndexes(start.content);
            section.ends = this.createInstanceIndexes(end.content);
            section.start = start;
            section.end = end;
            return section;
        }

        @Override
        public void onPage(long pageNumber, Object context) {
            if (context instanceof LayoutContext) {
                LayoutContext pdfContext = (LayoutContext)context;
                ReportDocumentBuilder.this.document.setPageCount(pageNumber);
                boolean reportFinished = pdfContext.isFinished();
                if (reportFinished) {
                    this.writePageVariables();
                    this.writeTotalPage(pageNumber);
                    this.close();
                    return;
                }
                boolean checkpoint = false;
                if (ReportDocumentBuilder.this.executionContext.isProgressiveViewingEnable() && (pageNumber == 1L || pageNumber == 10L || pageNumber == 50L || pageNumber % 100L == 0L)) {
                    checkpoint = true;
                }
                this.writePageHint(pdfContext);
                if (checkpoint) {
                    try {
                        IDocArchiveWriter archive = ReportDocumentBuilder.this.document.getArchive();
                        this.writeTotalPage(pageNumber);
                        ReportDocumentBuilder.this.document.savePersistentObjects(ReportDocumentBuilder.this.executionContext.getGlobalBeans());
                        ReportDocumentBuilder.this.document.saveCoreStreams();
                        archive.flush();
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, " check point failed ", e);
                    }
                }
                if (ReportDocumentBuilder.this.pageHandler != null) {
                    ReportDocumentInfo docInfo = new ReportDocumentInfo(ReportDocumentBuilder.this.executionContext, pageNumber, false);
                    ReportDocumentBuilder.this.pageHandler.onPage((int)pageNumber, checkpoint, docInfo);
                }
            }
            ReportDocumentBuilder.this.executionContext.getProgressMonitor().onProgress(4, (int)pageNumber);
        }
    }

    class PageEmitter
    extends ContentEmitterAdapter {
        PageEmitter() {
        }

        @Override
        public void startPage(IPageContent page) {
            ReportDocumentBuilder.this.pageNumber = page.getPageNumber();
            ReportDocumentBuilder.this.executionContext.getProgressMonitor().onProgress(3, (int)ReportDocumentBuilder.this.pageNumber);
            IArea pageArea = (IArea)page.getExtension(1);
            if (pageArea != null) {
                pageArea.accept(new BookmarkCollector());
            }
        }

        @Override
        public void startContent(IContent content) {
            this.addBookmark(content);
        }

        private void addBookmark(IContent content) {
            String bookmark = content.getBookmark();
            if (bookmark != null) {
                BookmarkContent bcontent = new BookmarkContent(bookmark, ContentUtil.getDesignID(content));
                bcontent.setPageNumber(ReportDocumentBuilder.this.pageNumber);
                ReportDocumentBuilder.this.document.setBookmark(bookmark, bcontent);
            }
        }

        private class BookmarkCollector
        implements IAreaVisitor {
            private BookmarkCollector() {
            }

            @Override
            public void visitText(ITextArea textArea) {
            }

            @Override
            public void visitAutoText(ITemplateArea templateArea) {
            }

            @Override
            public void visitImage(IImageArea imageArea) {
            }

            @Override
            public void visitContainer(IContainerArea container) {
                IContent content = ((ContainerArea)container).getContent();
                if (content != null) {
                    PageEmitter.this.addBookmark(content);
                }
                Iterator<IArea> iter = container.getChildren();
                while (iter.hasNext()) {
                    IArea child = iter.next();
                    child.accept(this);
                }
            }
        }
    }

    class ProcessorEmitter
    extends ContentEmitterAdapter {
        IContentProcessor processor;

        ProcessorEmitter(IContentProcessor processor) {
            this.processor = processor;
        }

        @Override
        public void end(IReportContent report) {
            try {
                this.processor.end(report);
            }
            catch (EngineException ex) {
                ReportDocumentBuilder.this.executionContext.addException(ex);
            }
        }

        @Override
        public void startContent(IContent content) {
            try {
                this.processor.startContent(content);
            }
            catch (EngineException ex) {
                ReportDocumentBuilder.this.executionContext.addException(ex);
            }
        }

        @Override
        public void endContent(IContent content) {
            try {
                this.processor.endContent(content);
            }
            catch (EngineException ex) {
                ReportDocumentBuilder.this.executionContext.addException(ex);
            }
        }

        @Override
        public void start(IReportContent report) {
            try {
                this.processor.start(report);
            }
            catch (EngineException ex) {
                ReportDocumentBuilder.this.executionContext.addException(ex);
            }
        }
    }
}

