/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.index.v2;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.btree.BTreeCursor;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.impl.BookmarkContent;
import org.eclipse.birt.report.engine.internal.index.v2.BTreeMap;
import org.eclipse.birt.report.engine.internal.index.v2.IndexConstants;

public class IndexReader
implements IndexConstants {
    int valueType;
    HashMap<String, Object> map;
    BTreeMap btree;

    public IndexReader(IDocArchiveReader archive, String name) throws IOException {
        if (archive.exists(name)) {
            RAInputStream input = archive.getInputStream(name);
            try {
                int version = this.readVersion(input.readInt(), name);
                switch (version) {
                    case 0: {
                        this.valueType = 1;
                        int type = input.readInt();
                        if (type == 1) {
                            DataInputStream di = new DataInputStream(input);
                            int entries = IOUtil.readInt(di);
                            this.map = new HashMap(entries);
                            int i = 0;
                            while (i < entries) {
                                String key = IOUtil.readString(di);
                                long offset = IOUtil.readLong(di);
                                this.map.put(key, new Long(offset));
                                ++i;
                            }
                        } else {
                            this.btree = BTreeMap.openTreeMap(archive, name, this.valueType);
                        }
                        break;
                    }
                    case 1: {
                        this.valueType = 2;
                        int type = input.readInt();
                        if (type == 1) {
                            DataInputStream di = new DataInputStream(input);
                            int entries = IOUtil.readInt(di);
                            this.map = new HashMap(entries);
                            int index = 0;
                            while (index < entries) {
                                String key = IOUtil.readString(di);
                                BookmarkContent bookmark = new BookmarkContent();
                                bookmark.readStream(di);
                                this.map.put(key, bookmark);
                                ++index;
                            }
                        } else {
                            this.btree = BTreeMap.openTreeMap(archive, name, this.valueType);
                        }
                        break;
                    }
                    default: {
                        throw new IOException("unsupported index version " + version);
                    }
                }
            }
            finally {
                input.close();
            }
        }
    }

    private int readVersion(int versionInDocument, String streamName) {
        if ((versionInDocument == 0 || versionInDocument == 1) && ("/reportlet".equals(streamName) || "/reportletBookmarks".equals(streamName))) {
            return 0;
        }
        return versionInDocument;
    }

    int getValueType() {
        return this.valueType;
    }

    private Object get(String key) throws IOException {
        if (this.map != null) {
            return this.map.get(key);
        }
        if (this.btree != null) {
            return this.btree.getValue(key);
        }
        return null;
    }

    Long getLong(String key) throws IOException {
        if (this.valueType != 1) {
            return null;
        }
        return (Long)this.get(key);
    }

    BookmarkContent getBookmarkContent(String key) throws IOException {
        if (this.valueType != 2) {
            return null;
        }
        return (BookmarkContent)this.get(key);
    }

    void close() throws IOException {
        this.map = null;
        if (this.btree != null) {
            try {
                this.btree.close();
            }
            finally {
                this.btree = null;
            }
        }
    }

    void forAllKeys(KeyListener listener) throws IOException {
        if (this.map != null) {
            for (String bookmark : this.map.keySet()) {
                listener.onKey(bookmark);
            }
        }
        if (this.btree != null) {
            BTreeCursor cursor = this.btree.createCursor();
            try {
                while (cursor.next()) {
                    String key = (String)cursor.getKey();
                    listener.onKey(key);
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    void forAllValues(ValueListener listener) throws IOException {
        if (this.valueType != 2) {
            return;
        }
        if (this.map != null) {
            for (Object v : this.map.values()) {
                listener.onValue((BookmarkContent)v);
            }
        }
        if (this.btree != null) {
            BTreeCursor cursor = this.btree.createCursor();
            try {
                while (cursor.next()) {
                    listener.onValue(cursor.getValue());
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    public static interface KeyListener {
        public void onKey(String var1);
    }

    public static interface ValueListener {
        public void onValue(Object var1);
    }
}

