/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.data.DataEngineFactory;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.data.dte.DteMetaInfoIOUtil;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.executor.EngineExtensionManager;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.engine.IDataExtension;
import org.eclipse.birt.report.engine.ir.Report;

public class DataInteractiveEngine
extends AbstractDataEngine {
    protected DataOutputStream dos;
    protected List<String[]> newMetaInfo = new ArrayList<String[]>();
    protected List<String[]> metaInfo = new ArrayList<String[]>();
    protected IBaseResultSet[] reportletResults;
    protected IDocArchiveWriter writer;
    protected IDocArchiveReader reader;

    public DataInteractiveEngine(DataEngineFactory factory, ExecutionContext context, IDocArchiveReader reader, IDocArchiveWriter writer) throws Exception {
        super(factory, context);
        this.writer = writer;
        this.reader = reader;
        DataSessionContext dteSessionContext = new DataSessionContext(4, context.getDesign(), context.getScriptContext(), context.getApplicationClassLoader());
        dteSessionContext.setDocumentReader(reader);
        dteSessionContext.setDocumentWriter(writer);
        dteSessionContext.setAppContext(context.getAppContext());
        DataEngineContext dteEngineContext = dteSessionContext.getDataEngineContext();
        dteEngineContext.setLocale(context.getLocale());
        dteEngineContext.setTimeZone(context.getTimeZone());
        String tempDir = this.getTempDir(context);
        if (tempDir != null) {
            dteEngineContext.setTmpdir(tempDir);
        }
        this.dteSession = DataRequestSession.newSession(dteSessionContext);
        this.initialize();
    }

    protected void initialize() throws Exception {
        this.loadDteMetaInfo(this.reader);
        if (this.writer != null && this.dos == null) {
            this.dos = new DataOutputStream(this.writer.createRandomAccessStream("/Data/snap_hierarchy"));
            DteMetaInfoIOUtil.startMetaInfo(this.dos);
        }
    }

    protected void updateMetaInfo() {
        String[] info;
        int i = 0;
        while (i < this.newMetaInfo.size()) {
            info = this.newMetaInfo.get(i);
            String pRsetId = info[0];
            String cfr_ignored_0 = info[1];
            String queryId = info[2];
            String rsetId = info[3];
            String cfr_ignored_1 = info[4];
            this.removeMetaInfo(pRsetId, queryId, rsetId);
            ++i;
        }
        i = 0;
        while (i < this.metaInfo.size()) {
            info = this.metaInfo.get(i);
            this.storeDteMetaInfo(info[0], info[1], info[2], info[3], info[4]);
            ++i;
        }
        this.newMetaInfo.clear();
        this.metaInfo.clear();
    }

    protected void removeMetaInfo(String parendId, String queryId, String rsetId) {
        Iterator<String[]> iter = this.metaInfo.iterator();
        while (iter.hasNext()) {
            String[] info = iter.next();
            String pId = info[0];
            String qId = info[2];
            String rsId = info[3];
            if (!queryId.equals(qId) || !this.equals(rsetId, rsId) || !this.equals(parendId, pId)) continue;
            iter.remove();
        }
    }

    protected boolean equals(String orginal, String destination) {
        if (orginal == null) {
            return destination == null;
        }
        return orginal.equals(destination);
    }

    protected void removeMetaInfo(String parentId, String queryId) {
        ArrayList<String> rsets = new ArrayList<String>();
        Iterator<String[]> iter = this.metaInfo.iterator();
        while (iter.hasNext()) {
            String[] info = iter.next();
            String pRsetId = info[0];
            String qId = info[2];
            String rsetId = info[3];
            if (!queryId.equals(qId) || (parentId != null || pRsetId != null) && (parentId == null || !parentId.equals(pRsetId))) continue;
            iter.remove();
            rsets.add(rsetId);
        }
        while (rsets.size() > 0) {
            ArrayList<String> temp = new ArrayList<String>();
            int i = 0;
            while (i < rsets.size()) {
                temp.addAll(this.removeMetaInfo((String)rsets.get(i)));
                ++i;
            }
            rsets = temp;
        }
    }

    protected List<String> removeMetaInfo(String queryId) {
        ArrayList<String> rsets = new ArrayList<String>();
        Iterator<String[]> iter = this.metaInfo.iterator();
        while (iter.hasNext()) {
            String[] info = iter.next();
            String pRsetId = info[0];
            if (!queryId.equals(pRsetId)) continue;
            iter.remove();
            rsets.add(info[3]);
        }
        return rsets;
    }

    private void storeDteMetaInfo(String pRsetId, String rawId, String queryId, String rsetId, String rowId) {
        if (this.dos != null) {
            try {
                if (this.context.isExecutingMasterPage() && pRsetId == null) {
                    rawId = "-1";
                }
                DteMetaInfoIOUtil.storeMetaInfo(this.dos, pRsetId, rawId, queryId, rsetId, rowId);
                this.newMetaInfo.add(new String[]{pRsetId, rawId, queryId, rsetId, rowId});
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage());
            }
        }
    }

    protected void loadDteMetaInfo(IDocArchiveReader reader) throws IOException {
        this.metaInfo = DteMetaInfoIOUtil.loadDteMetaInfo(reader);
        if (this.metaInfo != null) {
            int i = 0;
            while (i < this.metaInfo.size()) {
                String[] rsetRelation = this.metaInfo.get(i);
                String pRsetId = rsetRelation[0];
                String rowId = rsetRelation[1];
                String queryId = rsetRelation[2];
                String rsetId = rsetRelation[3];
                this.addResultSetRelation(pRsetId, rowId, queryId, rsetId);
                ++i;
            }
        }
    }

    @Override
    public String getResultIDByRowID(String pRsetId, String rawId, String queryId) {
        return null;
    }

    @Override
    protected void doPrepareQuery(Report report, Map appContext) {
        this.appContext = appContext;
        this.queryIDMap.putAll(report.getQueryIDs());
    }

    @Override
    protected IBaseResultSet doExecuteQuery(IBaseResultSet parentResult, IQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        String queryID = (String)this.queryIDMap.get(query);
        IBaseQueryResults parentQueryResults = null;
        if (parentResult != null) {
            parentQueryResults = parentResult.getQueryResults();
        }
        String[] resultIdAndRawId = this.loadResultSetID(parentResult, queryID);
        String resultSetID = null;
        String originalRawId = "-1";
        if (resultIdAndRawId != null) {
            resultSetID = resultIdAndRawId[0];
            originalRawId = resultIdAndRawId[1];
        }
        if (!this.context.needRefreshData()) {
            ((QueryDefinition)query).setQueryResultsID(resultSetID);
        } else {
            this.removeMetaInfo(parentQueryResults == null ? null : parentQueryResults.getID(), queryID, resultSetID);
        }
        this.processQueryExtensions(query);
        String pRsetId = null;
        String rowId = "-1";
        IBaseQueryResults dteResults = null;
        QueryResultSet resultSet = null;
        boolean needExecute = this.queryCache.needExecute(query, queryOwner, useCache);
        if (parentQueryResults == null) {
            if (!needExecute) {
                dteResults = this.getCachedQueryResult(query, parentResult);
            }
            if (dteResults == null) {
                IPreparedQuery pQuery = this.dteSession.prepare(query);
                dteResults = this.dteSession.execute((IBasePreparedQuery)pQuery, null, this.context.getScriptContext());
                this.putCachedQueryResult(query, dteResults.getID());
            }
            resultSet = new QueryResultSet(this, this.context, query, (IQueryResults)dteResults);
        } else {
            if (parentResult instanceof QueryResultSet) {
                pRsetId = ((QueryResultSet)parentResult).getQueryResultsID();
                rowId = String.valueOf(((QueryResultSet)parentResult).getRowIndex());
            } else {
                pRsetId = ((CubeResultSet)parentResult).getQueryResultsID();
                rowId = ((CubeResultSet)parentResult).getCellIndex();
            }
            parentResult.getRawID();
            if (!needExecute) {
                dteResults = this.getCachedQueryResult(query, parentResult);
            }
            if (dteResults == null) {
                IPreparedQuery pQuery = this.dteSession.prepare(query);
                dteResults = this.dteSession.execute((IBasePreparedQuery)pQuery, parentQueryResults, this.context.getScriptContext());
                this.putCachedQueryResult(query, dteResults.getID());
            }
            resultSet = new QueryResultSet(this, this.context, parentResult, query, (IQueryResults)dteResults);
        }
        resultSet.setBaseRSetID(resultSetID);
        this.storeDteMetaInfo(pRsetId, originalRawId, queryID, dteResults.getID(), rowId);
        return resultSet;
    }

    protected void processQueryExtensions(IDataQueryDefinition query) throws EngineException {
        String[] extensions = this.context.getEngineExtensions();
        if (extensions != null) {
            EngineExtensionManager manager = this.context.getEngineExtensionManager();
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extensionName = stringArray[n2];
                IDataExtension extension = manager.getDataExtension(extensionName);
                if (extension != null) {
                    extension.prepareQuery(query);
                }
                ++n2;
            }
        }
    }

    @Override
    protected IBaseResultSet doExecuteCube(IBaseResultSet parentResult, ICubeQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        IBaseQueryResults dteResults;
        String queryID = (String)this.queryIDMap.get(query);
        IBaseQueryResults parentQueryResults = null;
        if (parentResult != null) {
            parentQueryResults = parentResult.getQueryResults();
        }
        String[] resultIdAndRawId = this.loadResultSetID(parentResult, queryID);
        String resultSetID = null;
        String originalRawId = "-1";
        if (resultIdAndRawId != null) {
            resultSetID = resultIdAndRawId[0];
            originalRawId = resultIdAndRawId[1];
        }
        if (useCache) {
            String rsetId = String.valueOf(this.cachedQueryToResults.get(query));
            query.setQueryResultsID(rsetId);
        } else {
            query.setQueryResultsID(null);
        }
        if (!this.context.needRefreshData()) {
            query.setQueryResultsID(resultSetID);
        } else {
            query.setQueryResultsID(null);
            this.removeMetaInfo(parentQueryResults == null ? null : parentQueryResults.getID(), queryID, resultSetID);
        }
        IPreparedCubeQuery pQuery = this.dteSession.prepare(query, this.appContext);
        String pRsetId = null;
        String rowId = "-1";
        CubeResultSet resultSet = null;
        ScriptContext scriptContext = this.context.getScriptContext();
        if (parentQueryResults == null) {
            dteResults = this.dteSession.execute((IBasePreparedQuery)pQuery, null, scriptContext);
            resultSet = new CubeResultSet(this, this.context, query, (ICubeQueryResults)dteResults);
        } else {
            if (parentResult instanceof QueryResultSet) {
                pRsetId = ((QueryResultSet)parentResult).getQueryResultsID();
                rowId = String.valueOf(((QueryResultSet)parentResult).getRowIndex());
            } else {
                pRsetId = ((CubeResultSet)parentResult).getQueryResultsID();
                rowId = ((CubeResultSet)parentResult).getCellIndex();
            }
            parentResult.getRawID();
            dteResults = this.dteSession.execute((IBasePreparedQuery)pQuery, parentQueryResults, scriptContext);
            CubeResultSet cubeResultSet = new CubeResultSet((IDataEngine)this, this.context, parentResult, query, (ICubeQueryResults)dteResults);
            resultSet = cubeResultSet.getCubeCursor() == null ? null : cubeResultSet;
        }
        this.storeDteMetaInfo(pRsetId, originalRawId, queryID, dteResults.getID(), rowId);
        if (query.cacheQueryResults()) {
            this.cachedQueryToResults.put(query, dteResults.getID());
        }
        return resultSet;
    }

    private String[] loadResultSetID(IBaseResultSet parentResult, String queryID) throws BirtException {
        String[] result = null;
        if (parentResult == null) {
            if (this.context.isExecutingMasterPage()) {
                long pageNumber;
                result = this.getResultIDWithRawId(null, "-1", queryID);
                if (result == null && (result = this.getResultIDWithRawId(null, String.valueOf(pageNumber = this.context.getPageNumber()), queryID)) == null) {
                    result = this.getResultIDWithRawId(null, "1", queryID);
                }
            } else {
                result = this.getResultIDWithRawId(null, "-1", queryID);
            }
        } else {
            String pRsetId = parentResult instanceof QueryResultSet ? ((QueryResultSet)parentResult).getQueryResultsID() : ((CubeResultSet)parentResult).getQueryResultsID();
            String rowid = parentResult.getRawID();
            result = this.getResultIDWithRawId(pRsetId, rowid, queryID);
        }
        return result;
    }

    @Override
    public void shutdown() {
        this.updateMetaInfo();
        if (this.dos != null) {
            try {
                this.dos.close();
            }
            catch (IOException iOException) {}
            this.dos = null;
        }
        this.dteSession.shutdown();
    }
}

