/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.DBConfig;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

class SaxParser
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger(SaxParser.class.getName());
    private static final String TYPE = "type";
    private static final String POLICY = "Policy";
    private static final String NAME = "name";
    private static final String DRIVER = "Driver";
    private int currentPolicy = -1;
    private DBConfig dbConfig;

    public SaxParser(DBConfig config) {
        this.dbConfig = config;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        String elementName = qName;
        if (elementName.equals(DRIVER)) {
            this.dbConfig.putPolicy(atts.getValue(NAME), this.currentPolicy);
        } else if (elementName.equals(POLICY)) {
            String type = atts.getValue(TYPE);
            try {
                this.currentPolicy = Integer.parseInt(type);
            }
            catch (NumberFormatException numberFormatException) {
                this.currentPolicy = -1;
            }
        }
    }

    public void parse() {
        if (this.dbConfig.getConfigURL() == null) {
            return;
        }
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(this);
            BufferedInputStream is = new BufferedInputStream(this.dbConfig.getConfigURL().openStream());
            try {
                InputSource source = new InputSource(is);
                source.setEncoding(source.getEncoding());
                xmlReader.parse(source);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "failed to parse" + this.dbConfig.getConfigURL(), e);
        }
    }
}

