/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.Collection;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.executor.ComparatorUtil;
import org.eclipse.birt.data.engine.executor.DataSetDesignComparator;
import org.eclipse.birt.data.engine.executor.DataSourceDesignComparator;

public class DataSourceAndDataSet {
    private IBaseDataSourceDesign dataSourceDesign;
    private IBaseDataSetDesign dataSetDesign;
    private Collection paramterHints;
    private String cacheScopeID;
    private boolean enableSamplePreview = false;

    public static DataSourceAndDataSet newInstance(IBaseDataSourceDesign dataSourceDesign, IBaseDataSetDesign dataSetDesign, Collection paramterHints, String cacheScopeID, boolean enableSamplePreview) {
        DataSourceAndDataSet dataSourceAndSet = new DataSourceAndDataSet();
        dataSourceAndSet.dataSourceDesign = dataSourceDesign;
        dataSourceAndSet.dataSetDesign = dataSetDesign;
        dataSourceAndSet.paramterHints = paramterHints;
        dataSourceAndSet.cacheScopeID = cacheScopeID;
        dataSourceAndSet.enableSamplePreview = enableSamplePreview;
        return dataSourceAndSet;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dataSourceDesign == null ? 0 : this.dataSourceDesign.getName().hashCode());
        result = 31 * result + (this.dataSetDesign == null ? 0 : this.dataSetDesign.getName().hashCode());
        result = 31 * result + (this.cacheScopeID == null ? 0 : this.cacheScopeID.hashCode());
        return result;
    }

    public boolean isDataSourceDataSetEqual(DataSourceAndDataSet obj, boolean considerParam) {
        IBaseDataSourceDesign dataSourceDesign2 = obj.dataSourceDesign;
        IBaseDataSetDesign dataSetDesign2 = obj.dataSetDesign;
        Collection paramterHints2 = obj.paramterHints;
        if (this.dataSourceDesign == dataSourceDesign2) {
            if (this.dataSetDesign == dataSetDesign2) {
                if (!considerParam) {
                    return true;
                }
                if (ComparatorUtil.isEqualParameterHints(this.paramterHints, paramterHints2)) {
                    return true;
                }
            } else if (this.dataSetDesign == null || dataSetDesign2 == null) {
                return false;
            }
        } else {
            if (this.dataSourceDesign == null || dataSourceDesign2 == null) {
                return false;
            }
            if (this.dataSetDesign != dataSetDesign2 && (this.dataSetDesign == null || dataSetDesign2 == null)) {
                return false;
            }
        }
        if (!this.isEqualDataSourceDesign(this.dataSourceDesign, dataSourceDesign2)) {
            return false;
        }
        if (!this.isEqualDataSetDesign(this.dataSetDesign, dataSetDesign2)) {
            return false;
        }
        if (!considerParam) {
            return true;
        }
        return ComparatorUtil.isEqualParameterHints(this.paramterHints, paramterHints2);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DataSourceAndDataSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DataSourceAndDataSet candidate = (DataSourceAndDataSet)obj;
        if (this.cacheScopeID == null || candidate.cacheScopeID == null) {
            return this.isDataSourceDataSetEqual((DataSourceAndDataSet)obj, true);
        }
        if (!this.enableSamplePreview) {
            if (!this.cacheScopeID.equals(candidate.cacheScopeID)) {
                return false;
            }
            return this.isDataSourceDataSetEqual((DataSourceAndDataSet)obj, true);
        }
        return this.cacheScopeID.equals(candidate.cacheScopeID);
    }

    private boolean isEqualDataSourceDesign(IBaseDataSourceDesign dataSourceDesign, IBaseDataSourceDesign dataSourceDesign2) {
        return DataSourceDesignComparator.isEqualDataSourceDesign(dataSourceDesign, dataSourceDesign2);
    }

    private boolean isEqualDataSetDesign(IBaseDataSetDesign dataSetDesign, IBaseDataSetDesign dataSetDesign2) {
        return DataSetDesignComparator.isEqualDataSetDesign(dataSetDesign, dataSetDesign2);
    }

    public String getCacheScopeID() {
        return this.cacheScopeID;
    }
}

