/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.render;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.computation.withaxes.StackGroup;
import org.eclipse.birt.chart.computation.withaxes.StackedSeriesLookup;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.extension.datafeed.StockEntry;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.emf.common.util.EList;

public final class Stock
extends AxesRenderer {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine.extension/render");
    private static final int MIN_HOTSPOT_WIDTH = 12;

    @Override
    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        int iSharedUnitCount;
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        if (cwa.getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.stock.dimension", new Object[]{cwa.getDimension().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (this.isTransposed()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.no.transposed.stock.chart", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
        try {
            this.validateDataSetCount(isrh);
        }
        catch (ChartException vex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)vex);
        }
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        logger.log(1, Messages.getString("info.render.series", new Object[]{this.getClass().getName(), this.iSeriesIndex + 1, this.iSeriesCount}, this.getRunTimeContext().getULocale()));
        StockSeries ss = (StockSeries)this.getSeries();
        if (!ss.isVisible()) {
            this.restoreClipping(ipr);
            return;
        }
        double dSeriesThickness = srh.getSeriesThickness();
        DataPointHints[] dpha = srh.getDataPoints();
        LineAttributes lia = ss.getLineAttributes();
        double dUnitSpacing = !cwa.isSetUnitSpacing() ? 50.0 : cwa.getUnitSpacing();
        double dX = 0.0;
        double dY = 0.0;
        double dWidth = 0.0;
        double dHeight = 0.0;
        double dSpacing = 0.0;
        Location loStart = null;
        Location loEnd = null;
        Location loUpper = goFactory.createLocation(0.0, 0.0);
        Location loLower = goFactory.createLocation(0.0, 0.0);
        Location[] loaFrontFace = null;
        SeriesDefinition sd = this.getSeriesDefinition();
        EList<Fill> elPalette = sd.getSeriesPalette().getEntries();
        if (elPalette.isEmpty()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{ss}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean bPaletteByCategory = this.isPaletteByCategory();
        int iThisSeriesIndex = -1;
        Fill fPaletteEntry = null;
        if (!bPaletteByCategory) {
            iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ss);
            if (iThisSeriesIndex < 0) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ss, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
            }
            fPaletteEntry = FillUtil.getPaletteFill(elPalette, iThisSeriesIndex);
        }
        this.renderClipping(ipr, this.getPlotBounds());
        StackedSeriesLookup ssl = null;
        StackGroup sg = null;
        ssl = srh.getStackedSeriesLookup();
        sg = ssl.getStackGroup(ss);
        int iSharedUnitIndex = sg == null ? 0 : sg.getSharedIndex();
        int n = iSharedUnitCount = sg == null ? 1 : sg.getSharedCount();
        if (iSharedUnitCount == 1) {
            iSharedUnitIndex = 0;
        }
        double[] faX = new double[dpha.length];
        double[] faY = new double[dpha.length];
        AutoScale scale = this.getInternalOrthogonalAxis().getScale();
        int i = 0;
        while (i < dpha.length) {
            block25: {
                StockEntry se = (StockEntry)dpha[i].getOrthogonalValue();
                if (this.isValidEntry(se)) {
                    EList<Trigger> elTriggers;
                    double dClose;
                    double dOpen;
                    double dHigh;
                    double dLow;
                    this.correctEntry(se);
                    if (this.checkEntryInRange(se, scale.getMinimum(), scale.getMaximum()) > 0) {
                        dpha[i].markOutside();
                    }
                    fPaletteEntry = bPaletteByCategory ? FillUtil.getPaletteFill(elPalette, i) : FillUtil.getPaletteFill(elPalette, iThisSeriesIndex);
                    this.updateTranslucency(fPaletteEntry, ss);
                    Location lo = dpha[i].getLocation();
                    dX = lo.getX();
                    dY = lo.getY();
                    try {
                        dLow = srh.getLocationOnOrthogonal(new Double(se.getLow()));
                        dHigh = srh.getLocationOnOrthogonal(new Double(se.getHigh()));
                        dOpen = srh.getLocationOnOrthogonal(new Double(se.getOpen()));
                        dClose = srh.getLocationOnOrthogonal(new Double(se.getClose()));
                    }
                    catch (Exception ex) {
                        logger.log(ex);
                        break block25;
                    }
                    ScriptHandler.callFunction(sh, "beforeDrawElement", dpha[i], fPaletteEntry);
                    ScriptHandler.callFunction(sh, "beforeDrawDataPoint", dpha[i], fPaletteEntry, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawElement", dpha[i]);
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", dpha[i]);
                    dSpacing = dpha[i].getSize() * dUnitSpacing / 200.0;
                    if (loStart == null) {
                        loStart = goFactory.createLocation(0.0, 0.0);
                        loEnd = goFactory.createLocation(0.0, 0.0);
                        loaFrontFace = new Location[4];
                        int j = 0;
                        while (j < 4) {
                            loaFrontFace[j] = goFactory.createLocation(0.0, 0.0);
                            ++j;
                        }
                    }
                    dWidth = dpha[i].getSize();
                    dWidth -= 2.0 * dSpacing;
                    dWidth /= (double)iSharedUnitCount;
                    if (cwa.getBaseAxes()[0].isCategoryAxis()) {
                        dX += dSpacing + dWidth / 2.0 + (double)iSharedUnitIndex * dWidth;
                    }
                    LineRenderEvent lre = ((EventObjectCache)((Object)ipr)).getEventObject(WrappedStructureSource.createSeriesDataPoint(ss, dpha[i]), LineRenderEvent.class);
                    if (ss.isShowAsBarStick()) {
                        int stickLength = ss.getStickLength();
                        int hotspotHalfWidth = Math.min(stickLength, 6);
                        double hotspotHigh = Math.max(dHigh, dLow);
                        double hotspotLow = Math.min(dHigh, dLow);
                        loaFrontFace[0].set(dX - (double)hotspotHalfWidth, hotspotHigh);
                        loaFrontFace[1].set(dX - (double)hotspotHalfWidth, hotspotLow);
                        loaFrontFace[2].set(dX + (double)hotspotHalfWidth, hotspotLow);
                        loaFrontFace[3].set(dX + (double)hotspotHalfWidth, hotspotHigh);
                        Location loStart2 = goFactory.createLocation(0.0, 0.0);
                        Location loEnd2 = goFactory.createLocation(0.0, 0.0);
                        loStart.set(dX - (double)stickLength, dOpen);
                        loEnd.set(dX + (double)stickLength, dClose);
                        loStart2.set(dX, dOpen);
                        loEnd2.set(dX, dClose);
                        loUpper.set(dX, dHigh > dLow ? dHigh : dLow);
                        loLower.set(dX, dHigh < dLow ? dHigh : dLow);
                        lre.setLineAttributes(lia);
                        lre.setStart(loUpper);
                        lre.setEnd(loLower);
                        ipr.drawLine(lre);
                        lre.setStart(loStart);
                        lre.setEnd(loStart2);
                        ipr.drawLine(lre);
                        lre.setStart(loEnd);
                        lre.setEnd(loEnd2);
                        ipr.drawLine(lre);
                    } else {
                        loStart.set(dX, dLow);
                        loEnd.set(dX, dHigh);
                        loaFrontFace[0].set(dX - dWidth / 2.0, dOpen);
                        loaFrontFace[1].set(dX - dWidth / 2.0, dClose);
                        loaFrontFace[2].set(dX + dWidth / 2.0, dClose);
                        loaFrontFace[3].set(dX + dWidth / 2.0, dOpen);
                        loUpper.set(dX, dOpen > dClose ? dOpen : dClose);
                        loLower.set(dX, dOpen < dClose ? dOpen : dClose);
                        lre.setLineAttributes(lia);
                        lre.setStart(loStart);
                        lre.setEnd(loUpper);
                        ipr.drawLine(lre);
                        lre.setStart(loLower);
                        lre.setEnd(loEnd);
                        ipr.drawLine(lre);
                        this.renderPlane(ipr, WrappedStructureSource.createSeriesDataPoint(ss, dpha[i]), loaFrontFace, Stock.convertFill(fPaletteEntry, se.getClose() > se.getOpen()), lia, cwa.getDimension(), dSeriesThickness, true);
                    }
                    if (cwa.isTransposed()) {
                        faX[i] = (loUpper.getX() + loLower.getX()) / 2.0;
                        faY[i] = loUpper.getY();
                    } else {
                        faX[i] = loLower.getX();
                        faY[i] = (loUpper.getY() + loLower.getY()) / 2.0;
                    }
                    if (this.isInteractivityEnabled() && !(elTriggers = ss.getTriggers()).isEmpty()) {
                        StructureSource iSource = WrappedStructureSource.createSeriesDataPoint(ss, dpha[i]);
                        InteractionEvent iev = ((EventObjectCache)((Object)ipr)).getEventObject(iSource, InteractionEvent.class);
                        iev.setCursor(ss.getCursor());
                        int t = 0;
                        while (t < elTriggers.size()) {
                            Trigger tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                            this.processTrigger(tg, iSource);
                            iev.addTrigger(tg);
                            ++t;
                        }
                        PolygonRenderEvent pre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createSeries(ss), PolygonRenderEvent.class);
                        pre.setPoints(loaFrontFace);
                        iev.setHotSpot(pre);
                        ipr.enableInteraction(iev);
                    }
                    ScriptHandler.callFunction(sh, "afterDrawElement", dpha[i], fPaletteEntry);
                    ScriptHandler.callFunction(sh, "afterDrawDataPoint", dpha[i], fPaletteEntry, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawElement", dpha[i]);
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", dpha[i]);
                    this.renderDataPointLabel(srh.getLabelAttributes(this.getSeries()), dpha[i], srh.getLabelPosition(this.getSeries()), loaFrontFace, p, sh, dX, dY, dWidth, dHeight, dHigh, dLow, dOpen, dClose);
                }
            }
            ++i;
        }
        if (this.getSeries().getCurveFitting() != null) {
            Location[] larray = new Location[faX.length];
            int i2 = 0;
            while (i2 < larray.length) {
                larray[i2] = goFactory.createLocation(faX[i2], faY[i2]);
                ++i2;
            }
            larray = this.filterNull(larray);
            this.renderFittingCurve(ipr, larray, this.getSeries().getCurveFitting(), false, true);
        }
        this.restoreClipping(ipr);
    }

    @Override
    public void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        StockSeries ss = (StockSeries)this.getSeries();
        LineAttributes lia = ss.getLineAttributes();
        if (!lia.isVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.stock.lineattr.visibility", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        LineRenderEvent lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createLegend(lg), LineRenderEvent.class);
        if (ss.isShowAsBarStick()) {
            int stickLength = ss.getStickLength();
            lre.setLineAttributes(lia);
            lre.setStart(goFactory.createLocation(bo.getLeft() + bo.getWidth() / 2.0, bo.getTop()));
            lre.setEnd(goFactory.createLocation(bo.getLeft() + bo.getWidth() / 2.0, bo.getTop() + bo.getHeight()));
            ipr.drawLine(lre);
            lre.setStart(goFactory.createLocation(bo.getLeft() + bo.getWidth() / 2.0 - (double)stickLength, bo.getTop() + bo.getHeight() * 3.0 / 4.0));
            lre.setEnd(goFactory.createLocation(bo.getLeft() + bo.getWidth() / 2.0, bo.getTop() + bo.getHeight() * 3.0 / 4.0));
            ipr.drawLine(lre);
            lre.setStart(goFactory.createLocation(bo.getLeft() + bo.getWidth() / 2.0, bo.getTop() + bo.getHeight() / 4.0));
            lre.setEnd(goFactory.createLocation(bo.getLeft() + bo.getWidth() / 2.0 + (double)stickLength, bo.getTop() + bo.getHeight() / 4.0));
            ipr.drawLine(lre);
        } else {
            RectangleRenderEvent rre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createLegend(lg), RectangleRenderEvent.class);
            rre.setBackground(fPaletteEntry);
            rre.setOutline(lia);
            rre.setBounds(goFactory.createBounds(bo.getLeft() + 1.0, bo.getTop() + bo.getHeight() / 4.0, bo.getWidth() - 2.0, bo.getHeight() / 2.0));
            lre.setLineAttributes(lia);
            lre.setStart(goFactory.createLocation(bo.getLeft() + bo.getWidth() / 2.0, bo.getTop() + bo.getHeight()));
            lre.setEnd(goFactory.createLocation(bo.getLeft() + bo.getWidth() / 2.0, bo.getTop()));
            ipr.drawLine(lre);
            ipr.fillRectangle(rre);
            ipr.drawRectangle(rre);
        }
    }

    private boolean isValidEntry(StockEntry entry) {
        return entry != null && entry.isValid();
    }

    private void correctEntry(StockEntry entry) {
        double dLow;
        double dHigh;
        if (entry.getOpen() > entry.getClose()) {
            dHigh = entry.getOpen();
            dLow = entry.getClose();
        } else {
            dHigh = entry.getClose();
            dLow = entry.getOpen();
        }
        if (entry.getHigh() < entry.getLow()) {
            logger.log(new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.stock.entry.invalid.highlow", new Object[]{new Double(entry.getHigh()), new Double(entry.getLow())}, Messages.getResourceBundle(this.getRunTimeContext().getULocale())));
            entry.setHigh(dHigh);
            entry.setLow(dLow);
        }
        if (entry.getHigh() < dHigh) {
            logger.log(new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.stock.entry.invalid.high", new Object[]{new Double(entry.getHigh()), new Double(dHigh)}, Messages.getResourceBundle(this.getRunTimeContext().getULocale())));
            entry.setHigh(dHigh);
        }
        if (entry.getLow() > dLow) {
            logger.log(new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.stock.entry.invalid.low", new Object[]{new Double(entry.getLow()), new Double(dLow)}, Messages.getResourceBundle(this.getRunTimeContext().getULocale())));
            entry.setLow(dLow);
        }
    }

    @Override
    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
    }

    protected void renderDataPointLabel(Label laDataPoint, DataPointHints dph, Position pDataPoint, Location[] loaFrontFace, Plot p, AbstractScriptHandler<?> sh, double dX, double dY, double dWidth, double dHeight, double dHigh, double dLow, double dOpen, double dClose) throws ChartException {
        laDataPoint.getCaption().setValue(dph.getDisplayValue());
        ScriptHandler.callFunction(sh, "beforeDrawDataPointLabel", dph, laDataPoint, this.getRunTimeContext().getScriptContext());
        this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", laDataPoint);
        if (laDataPoint.isVisible() && !dph.isOutside()) {
            Location loDataPoint = goFactory.createLocation(0.0, 0.0);
            if (((StockSeries)this.getSeries()).isShowAsBarStick()) {
                dWidth = ((StockSeries)this.getSeries()).getStickLength();
            }
            switch (pDataPoint.getValue()) {
                case 0: 
                case 4: 
                case 5: {
                    loDataPoint.set(dX, dHigh - (double)p.getVerticalSpacing());
                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint(this.getSeries(), dph), 2, laDataPoint, Position.ABOVE_LITERAL, loDataPoint, null);
                    break;
                }
                case 1: {
                    loDataPoint.set(dX, dLow + (double)p.getVerticalSpacing());
                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint(this.getSeries(), dph), 2, laDataPoint, Position.BELOW_LITERAL, loDataPoint, null);
                    break;
                }
                case 2: {
                    loDataPoint.set(dX - dWidth / 2.0 - (double)p.getHorizontalSpacing(), (dOpen + dClose) / 2.0);
                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint(this.getSeries(), dph), 2, laDataPoint, Position.LEFT_LITERAL, loDataPoint, null);
                    break;
                }
                case 3: {
                    loDataPoint.set(dX + dWidth / 2.0 + (double)p.getHorizontalSpacing(), (dOpen + dClose) / 2.0);
                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint(this.getSeries(), dph), 2, laDataPoint, Position.RIGHT_LITERAL, loDataPoint, null);
                    break;
                }
                default: {
                    logger.log(new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.stock", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale())));
                }
            }
        }
        ScriptHandler.callFunction(sh, "afterDrawDataPointLabel", dph, laDataPoint, this.getRunTimeContext().getScriptContext());
        this.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", laDataPoint);
    }

    @Override
    protected int checkEntryInRange(Object entry, Object min, Object max) {
        if (entry instanceof StockEntry) {
            StockEntry se = (StockEntry)entry;
            double dMin = Methods.asDouble(min);
            double dMax = Methods.asDouble(max);
            if (se.getLow() < dMin) {
                return 1;
            }
            if (se.getHigh() > dMax) {
                return 2;
            }
            return 0;
        }
        return super.checkEntryInRange(entry, min, max);
    }

    static Fill convertFill(Fill fill, boolean bIncrease) {
        if (bIncrease) {
            fill = fill instanceof MultipleFill ? goFactory.copyOf((Fill)((MultipleFill)fill).getFills().get(0)) : ColorDefinitionImpl.WHITE();
        } else if (fill instanceof MultipleFill) {
            fill = goFactory.copyOf((Fill)((MultipleFill)fill).getFills().get(1));
        }
        return fill;
    }
}

