/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.structures.ExtendedProperty;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.metadata.ODAExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.CompatibleListPropertyState;
import org.eclipse.birt.report.model.parser.CompatibleOdaDataSourcePropertyState;
import org.eclipse.birt.report.model.parser.CompatibleStructureState;
import org.eclipse.birt.report.model.parser.DesignParseState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.xml.sax.SAXException;

public class CompatibleOdaDriverPropertyStructureListState
extends CompatibleListPropertyState {
    CompatibleOdaDriverPropertyStructureListState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
        this.setProperty("extensionID", "org.eclipse.birt.report.data.oda.jdbc");
    }

    public AbstractParseState startElement(String tagName) {
        if (tagName.equalsIgnoreCase("ex-property")) {
            return new CompatibleOdaDriverPropertyStructureState(this.handler, this.element, this.propDefn);
        }
        return super.startElement(tagName);
    }

    public void end() throws SAXException {
        if (this.list == null || this.list.isEmpty()) {
            return;
        }
        this.name = "privateDriverProperties";
        super.end();
    }

    static class CompatibleOdaDriverPropertyStructureState
    extends CompatibleStructureState {
        String propertyName = null;
        String propertyValue = null;
        List privatePropDefns = Collections.EMPTY_LIST;

        CompatibleOdaDriverPropertyStructureState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn) {
            super(theHandler, element);
            ODAExtensionElementDefn elementDefn = null;
            if (element instanceof OdaDataSet) {
                elementDefn = (ODAExtensionElementDefn)((OdaDataSet)element).getExtDefn();
                propDefn = element.getPropertyDefn("privateDriverProperties");
            } else if (element instanceof OdaDataSource) {
                elementDefn = (ODAExtensionElementDefn)((OdaDataSource)element).getExtDefn();
                propDefn = element.getPropertyDefn("privateDriverProperties");
            }
            if (elementDefn != null) {
                this.privatePropDefns = elementDefn.getODAPrivateDriverPropertyNames();
            }
            this.name = propDefn.getName();
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase("name")) {
                return new CompatibleTextState(this.handler, true, this);
            }
            if (tagName.equalsIgnoreCase("value")) {
                return new CompatibleTextState(this.handler, false, this);
            }
            return super.startElement(tagName);
        }

        public void end() throws SAXException {
            if (this.propertyValue != null && this.propertyName != null) {
                String newPropertyName = CompatibleOdaDataSourcePropertyState.getNewOdaDriverProperty(this.propertyName);
                if (!this.privatePropDefns.contains(newPropertyName)) {
                    this.setProperty(newPropertyName, this.propertyValue);
                } else {
                    this.struct = new ExtendedProperty();
                    this.setMember(this.struct, this.propDefn.getName(), "name", newPropertyName);
                    this.setMember(this.struct, this.propDefn.getName(), "value", this.propertyValue);
                    super.end();
                }
            }
        }
    }

    static class CompatibleTextState
    extends DesignParseState {
        boolean isPropertyName = false;
        CompatibleOdaDriverPropertyStructureState state;

        CompatibleTextState(ModuleParserHandler handler, boolean isPropertyName, CompatibleOdaDriverPropertyStructureState state) {
            super(handler);
            this.isPropertyName = isPropertyName;
            this.state = state;
        }

        public DesignElement getElement() {
            return null;
        }

        public void end() throws SAXException {
            String value = this.text.toString();
            if (this.isPropertyName) {
                this.state.propertyName = value;
            } else {
                this.state.propertyValue = value;
            }
        }
    }
}

