/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class ExtendsPropertyType
extends PropertyType {
    private static Logger logger = Logger.getLogger(ExtendsPropertyType.class.getName());
    private static final String DISPLAY_NAME_KEY = "Property.extends";

    public ExtendsPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public int getTypeCode() {
        return 17;
    }

    public String getName() {
        return "extends";
    }

    public Object validateValue(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String name = StringUtil.trimString((String)value);
            if (name == null) {
                return null;
            }
            return this.validateStringValue(module, defn, (String)value);
        }
        if (value instanceof DesignElement) {
            return this.validateElementValue(module, defn, (DesignElement)value);
        }
        logger.log(Level.SEVERE, "The value of the extends property is not a valid type ");
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 17);
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        ElementRefValue refValue = (ElementRefValue)value;
        return refValue.getQualifiedReference();
    }

    private ElementRefValue validateElementValue(Module module, PropertyDefn targetDefn, DesignElement target) throws PropertyValueException {
        return new ElementRefValue(null, target);
    }

    private ElementRefValue validateStringValue(Module module, PropertyDefn targetDefn, String name) throws PropertyValueException {
        String namespace = StringUtil.extractNamespace(name);
        name = StringUtil.extractName(name);
        return new ElementRefValue(namespace, name);
    }
}

