/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TOCComparator
implements Comparator<String> {
    static final int PREFIX_LENGTH = 6;

    @Override
    public int compare(String o1, String o2) {
        int length1 = o1.length();
        int length2 = o2.length();
        if (length1 <= 6) {
            return -1;
        }
        if (length2 <= 6) {
            return 1;
        }
        for (int offset = 6; offset < length1 && offset < length2; ++offset) {
            int remainDigits2;
            char ch2;
            char ch1 = o1.charAt(offset);
            if (ch1 == (ch2 = o2.charAt(offset))) {
                continue;
            }
            if (ch1 == '_') {
                return -1;
            }
            if (ch2 == '_') {
                return 1;
            }
            int remainDigits1 = this.getCharsTillEnd(o1, offset + 1);
            if (remainDigits1 < (remainDigits2 = this.getCharsTillEnd(o2, offset + 1))) {
                return -1;
            }
            if (remainDigits1 > remainDigits2) {
                return 1;
            }
            if (ch1 < ch2) {
                return -1;
            }
            return 1;
        }
        if (length1 < length2) {
            return -1;
        }
        if (length1 > length2) {
            return 1;
        }
        return 0;
    }

    int getCharsTillEnd(String o, int offset) {
        int length = o.length();
        int chars = offset;
        while (chars < length) {
            char ch = o.charAt(chars);
            if (ch == '_') {
                return chars - offset;
            }
            ++chars;
        }
        return length - offset;
    }
}

