/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import org.eclipse.birt.report.engine.executor.buffermgr.Cell;
import org.eclipse.birt.report.engine.executor.buffermgr.Row;
import org.eclipse.birt.report.engine.executor.buffermgr.Table;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;

public class TableItemDesignLayout {
    Table layout = new Table();

    public long layout(GridItemDesign grid, long newCellId) {
        this.layout = new Table(0, grid.getColumnCount());
        this.layout.reset();
        int i = 0;
        while (i < grid.getRowCount()) {
            this.layoutRow(grid.getRow(i));
            ++i;
        }
        this.layout.resolveDropCells();
        i = grid.getColumnCount();
        while (i < this.layout.getColCount()) {
            grid.addColumn(new ColumnDesign());
            ++i;
        }
        newCellId = this.normalize(newCellId);
        i = grid.getColumnCount();
        while (i < this.layout.getColCount()) {
            grid.addColumn(new ColumnDesign());
            ++i;
        }
        return newCellId;
    }

    protected long normalize(long newCellId) {
        int i = 0;
        while (i < this.layout.getRowCount()) {
            Row row = this.layout.getRow(i);
            RowDesign design = (RowDesign)row.getContent();
            design.removeCells();
            int j = 0;
            while (j < this.layout.getColCount()) {
                CellDesign cellDesign;
                Cell cell = row.getCell(j);
                if (cell.getStatus() == 0) {
                    cellDesign = new CellDesign();
                    cellDesign.setRowSpan(1);
                    cellDesign.setColSpan(1);
                    cellDesign.setColumn(j);
                    cellDesign.setID(--newCellId);
                    design.addCell(cellDesign);
                }
                if (cell.getStatus() == 1) {
                    cellDesign = ((CellContent)cell.getContent()).cell;
                    cellDesign.setColSpan(cell.getColSpan());
                    cellDesign.setRowSpan(cell.getRowSpan());
                    cellDesign.setColumn(j);
                    design.addCell(cellDesign);
                }
                ++j;
            }
            ++i;
        }
        return newCellId;
    }

    public long layout(TableItemDesign table, long newCellId) {
        GroupDesign group;
        this.layout = new Table(0, table.getColumnCount());
        this.layoutBand((TableBandDesign)table.getHeader());
        int i = 0;
        while (i < table.getGroupCount()) {
            group = table.getGroup(i);
            TableBandDesign header = (TableBandDesign)group.getHeader();
            this.layoutBand(header);
            ++i;
        }
        this.layoutBand((TableBandDesign)table.getDetail());
        i = table.getGroupCount() - 1;
        while (i >= 0) {
            group = table.getGroup(i);
            TableBandDesign footer = (TableBandDesign)group.getFooter();
            this.layoutBand(footer);
            --i;
        }
        this.layoutBand((TableBandDesign)table.getFooter());
        newCellId = this.normalize(newCellId);
        i = table.getColumnCount();
        while (i < this.layout.getColCount()) {
            table.addColumn(new ColumnDesign());
            ++i;
        }
        return newCellId;
    }

    void layoutBand(TableBandDesign band) {
        if (band != null) {
            int i = 0;
            while (i < band.getRowCount()) {
                this.layoutRow(band.getRow(i));
                ++i;
            }
            this.layout.resolveDropCells();
        }
    }

    void layoutRow(RowDesign row) {
        this.layout.createRow(row);
        int i = 0;
        while (i < row.getCellCount()) {
            CellDesign cell = row.getCell(i);
            int columnNo = cell.getColumn();
            int rowSpan = cell.getRowSpan();
            int colSpan = cell.getColSpan();
            this.layout.createCell(columnNo, rowSpan, colSpan, new CellContent(cell));
            ++i;
        }
    }

    private static class CellContent
    implements Cell.Content {
        CellDesign cell;

        CellContent(CellDesign cell) {
            this.cell = cell;
        }

        public boolean isEmpty() {
            return this.cell != null;
        }

        public void reset() {
        }
    }
}

