/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.presentation;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportDocumentInfo;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.internal.presentation.TransientReportDocument;

public class ReportDocumentInfo
implements IReportDocumentInfo {
    protected ExecutionContext context;
    protected long pageNumber;
    protected boolean finished;
    protected Map params = new HashMap();
    protected Map parameterDisplayTexts = new HashMap();
    protected Map beans = new HashMap();
    protected List errors;

    public ReportDocumentInfo(ExecutionContext context, long pageNumber, boolean finished) {
        this.context = context;
        this.pageNumber = pageNumber;
        this.finished = finished;
        this.params.putAll(context.getParameterValues());
        this.parameterDisplayTexts.putAll(context.getParameterDisplayTexts());
        this.beans.putAll(context.getGlobalBeans());
        this.errors = context.getErrors();
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public boolean isComplete() {
        return this.finished;
    }

    public IReportDocument openReportDocument() throws BirtException {
        IDocArchiveWriter arcWriter;
        char lastChar;
        ReportEngine engine = this.context.getEngine();
        ReportDocumentWriter writer = this.context.getReportDocWriter();
        String documentName = writer.getName();
        if (new File(documentName).isDirectory() && (lastChar = documentName.charAt(documentName.length() - 1)) != '\\' && lastChar != '/' && lastChar != File.separatorChar) {
            documentName = String.valueOf(documentName) + File.separatorChar;
        }
        if ((arcWriter = writer.getArchive()) instanceof ArchiveWriter) {
            IArchiveFile archive = ((ArchiveWriter)arcWriter).getArchive();
            try {
                ArchiveReader arcReader = new ArchiveReader(archive);
                IReportDocument document = engine.openReportDocument(documentName, arcReader, new HashMap());
                return new TransientReportDocument(document, this.context, this.pageNumber, this.params, this.parameterDisplayTexts, this.beans, this.finished);
            }
            catch (IOException ex) {
                throw new EngineException("Error.ReportDocmentOpenError", ex);
            }
        }
        throw new EngineException("Error.ReportDocmentOpenError");
    }

    public List getErrors() {
        return this.errors;
    }
}

