/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.GroupExecutor;
import org.eclipse.birt.report.engine.executor.TableBandExecutor;
import org.eclipse.birt.report.engine.executor.TableItemExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;

public class TableGroupExecutor
extends GroupExecutor {
    protected TableGroupExecutor(ExecutorManager manager) {
        super(manager, 16);
    }

    public void close() throws BirtException {
        this.handlePageBreakAfterExclusingLast();
        this.handlePageBreakAfter();
        this.finishGroupTOCEntry();
        super.close();
    }

    public IContent execute() {
        TableGroupDesign groupDesign = (TableGroupDesign)this.getDesign();
        ITableGroupContent groupContent = this.report.createTableGroupContent();
        this.setContent(groupContent);
        this.restoreResultSet();
        this.initializeContent(groupDesign, groupContent);
        this.processBookmark(groupDesign, groupContent);
        this.handlePageBreakInsideOfGroup();
        this.handlePageBreakBeforeOfGroup();
        this.handlePageBreakAfterOfGroup();
        this.handlePageBreakAfterOfPreviousGroup();
        this.handlePageBreakBefore();
        this.handlePageBreakInterval();
        if (this.context.isInFactory()) {
            this.handleOnCreate(groupContent);
        }
        this.startGroupTOCEntry(groupContent);
        this.prepareToExecuteChildren();
        return groupContent;
    }

    public IReportItemExecutor getNextChild() {
        IReportItemExecutor executor = super.getNextChild();
        if (executor instanceof TableBandExecutor) {
            TableBandExecutor bandExecutor = (TableBandExecutor)executor;
            bandExecutor.setTableExecutor((TableItemExecutor)this.listingExecutor);
        }
        return executor;
    }
}

