/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config.ods;

import org.eclipse.birt.report.engine.api.EXCELRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.emitter.config.AbstractConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.AbstractEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.ConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.IOptionValue;
import org.eclipse.birt.report.engine.emitter.config.ods.i18n.Messages;

public class OdsEmitterDescriptor
extends AbstractEmitterDescriptor {
    protected static final String TEXT_WRAPPING = "TextWrapping";
    protected static final String CHART_DPI = "ChartDpi";
    private static final String HIDE_GRIDLINES = "HideGridlines";

    protected void initOptions() {
        this.loadDefaultValues("org.eclipse.birt.report.engine.emitter.config.ods");
        ConfigurableOption wrappingText = this.initializeWrappingText();
        ConfigurableOption chartDpi = new ConfigurableOption(CHART_DPI);
        chartDpi.setDisplayName(this.getMessage("OptionDisplayValue.ChartDpi"));
        chartDpi.setDataType(IConfigurableOption.DataType.INTEGER);
        chartDpi.setDisplayType(IConfigurableOption.DisplayType.TEXT);
        chartDpi.setDefaultValue(new Integer(192));
        chartDpi.setToolTip(this.getMessage("Tooltip.ChartDpi"));
        chartDpi.setDescription(this.getMessage("OptionDescription.ChartDpi"));
        ConfigurableOption hideGridlines = new ConfigurableOption(HIDE_GRIDLINES);
        hideGridlines.setDisplayName(this.getMessage("OptionDisplayValue.HideGridlines"));
        hideGridlines.setDataType(IConfigurableOption.DataType.BOOLEAN);
        hideGridlines.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        hideGridlines.setDefaultValue(Boolean.FALSE);
        hideGridlines.setToolTip(null);
        hideGridlines.setDescription(this.getMessage("OptionDescription.HideGridlines"));
        this.options = new IConfigurableOption[]{wrappingText, chartDpi};
        this.applyDefaultValues();
    }

    protected String getMessage(String key) {
        return Messages.getString(key, this.locale);
    }

    protected ConfigurableOption initializeWrappingText() {
        ConfigurableOption wrappingText = new ConfigurableOption(TEXT_WRAPPING);
        wrappingText.setDisplayName(this.getMessage("OptionDisplayValue.WrappingText"));
        wrappingText.setDataType(IConfigurableOption.DataType.BOOLEAN);
        wrappingText.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        wrappingText.setDefaultValue(Boolean.TRUE);
        wrappingText.setToolTip(null);
        wrappingText.setDescription(this.getMessage("OptionDescription.WrappingText"));
        return wrappingText;
    }

    public IConfigurableOptionObserver createOptionObserver() {
        return new OdsOptionObserver();
    }

    public String getDescription() {
        return this.getMessage("OdsEmitter.Description");
    }

    public String getDisplayName() {
        return this.getMessage("OdsEmitter.DisplayName");
    }

    public String getID() {
        return "org.eclipse.birt.report.engine.emitter.prototype.ods";
    }

    public String getRenderOptionName(String name) {
        assert (name != null);
        if (TEXT_WRAPPING.equals(name)) {
            return "excelRenderOption.wrappingText";
        }
        if (CHART_DPI.equals(name)) {
            return CHART_DPI;
        }
        if (HIDE_GRIDLINES.equals(name)) {
            return "excelRenderOption.hideGridlines";
        }
        return name;
    }

    class OdsOptionObserver
    extends AbstractConfigurableOptionObserver {
        OdsOptionObserver() {
        }

        public IConfigurableOption[] getOptions() {
            return OdsEmitterDescriptor.this.options;
        }

        public IRenderOption getPreferredRenderOption() {
            EXCELRenderOption renderOption = new EXCELRenderOption();
            renderOption.setEmitterID(OdsEmitterDescriptor.this.getID());
            renderOption.setOutputFormat("ods");
            if (this.values != null && this.values.length > 0) {
                IOptionValue[] iOptionValueArray = this.values;
                int n = this.values.length;
                int n2 = 0;
                while (n2 < n) {
                    IOptionValue optionValue = iOptionValueArray[n2];
                    if (optionValue != null) {
                        renderOption.setOption(OdsEmitterDescriptor.this.getRenderOptionName(optionValue.getName()), optionValue.getValue());
                    }
                    ++n2;
                }
            }
            return renderOption;
        }
    }
}

