/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.impl.DataIterator;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;

public class ExtractionResults
implements IExtractionResults {
    protected IQueryResults queryResults;
    protected IResultMetaData metaData;
    protected IDataIterator iterator;
    protected IResultIterator resultIterator;
    protected int startRow;
    protected int maxRows;

    public ExtractionResults(IQueryResults queryResults, IResultMetaData metaData, String[] selectedColumns, int startRow, int maxRows) {
        this.queryResults = queryResults;
        this.metaData = selectedColumns == null ? metaData : new ResultMetaData(metaData, selectedColumns);
        this.startRow = startRow;
        this.maxRows = maxRows;
    }

    public ExtractionResults(IResultIterator resultIterator, IResultMetaData metaData, String[] selectedColumns, int startRow, int maxRows) {
        this.resultIterator = resultIterator;
        this.metaData = selectedColumns == null ? metaData : new ResultMetaData(metaData, selectedColumns);
        this.startRow = startRow;
        this.maxRows = maxRows;
    }

    public IResultMetaData getResultMetaData() throws BirtException {
        return this.metaData;
    }

    public IDataIterator nextResultIterator() throws BirtException {
        if (this.iterator == null) {
            if (this.resultIterator == null && this.queryResults != null) {
                this.resultIterator = this.queryResults.getResultIterator();
            }
            this.iterator = new DataIterator(this, this.resultIterator, this.startRow, this.maxRows);
        }
        return this.iterator;
    }

    public void close() {
        if (this.queryResults != null) {
            try {
                this.queryResults.close();
            }
            catch (BirtException birtException) {}
            this.queryResults = null;
        }
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
    }
}

