/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.dbprofile.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.impl.DBProfileStatement;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.impl.PropertyAdapter;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.nls.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.services.impl.ProviderUtil;
import org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer;
import org.eclipse.datatools.connectivity.oda.profile.internal.OdaConnectionProfile;
import org.eclipse.datatools.connectivity.oda.profile.internal.OdaProfileFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection
extends org.eclipse.birt.report.data.oda.jdbc.Connection
implements org.eclipse.datatools.connectivity.oda.IConnection {
    protected static final String SQB_DATA_SET_TYPE = "org.eclipse.birt.report.data.oda.jdbc.dbprofile.sqbDataSet";
    private static final String JDBC_CONN_TYPE = "java.sql.Connection";
    private static final String sm_className = Connection.class.getName();
    private static final String sm_packageName = Connection.class.getPackage().getName();
    private static final Logger sm_logger = Logger.getLogger(sm_packageName);
    private IConnectionProfile m_dbProfile;

    @Override
    public void open(Properties connProperties) throws OdaException {
        OdaException originalEx = null;
        try {
            IConnectionProfile dbProfile = this.getProfile(connProperties);
            this.open(dbProfile);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "open(Properties)", Messages.connection_openFailed, ex);
            originalEx = ex;
        }
        try {
            if (!this.isOpen()) {
                this.openJdbcConnection(connProperties);
            }
        }
        catch (OdaException odaException) {
            if (originalEx != null) {
                throw originalEx;
            }
            throw new OdaException(Messages.connection_openFailed);
        }
    }

    protected IConnectionProfile getProfile(Properties connProperties) throws OdaException {
        return Connection.loadProfileFromProperties(connProperties, this.getAppContextMap());
    }

    protected void openJdbcConnection(Properties profileProperties) throws OdaException {
        super.open(profileProperties);
    }

    public void open(IConnectionProfile dbProfile) throws OdaException {
        this.jdbcConn = null;
        this.m_dbProfile = dbProfile;
        if (this.m_dbProfile == null) {
            throw new OdaException(Messages.connection_nullProfile);
        }
        IStatus connectStatus = Connection.openWithProfile(this.m_dbProfile);
        if (connectStatus == null || connectStatus.getSeverity() > 1) {
            throw new OdaException(Connection.getStatusException(connectStatus));
        }
        this.jdbcConn = this.getJDBCConnection(this.m_dbProfile);
    }

    public static IStatus openWithProfile(IConnectionProfile connProfile) {
        if (connProfile instanceof OdaConnectionProfile) {
            return ((OdaConnectionProfile)connProfile).connectSynchronously();
        }
        return connProfile.connect();
    }

    private java.sql.Connection getJDBCConnection(IConnectionProfile dbProfile) {
        if (dbProfile == null) {
            return null;
        }
        IManagedConnection mgtConn = dbProfile.getManagedConnection(JDBC_CONN_TYPE);
        if (mgtConn == null) {
            return null;
        }
        IConnection connObj = mgtConn.getConnection();
        if (connObj == null) {
            return null;
        }
        java.sql.Connection jdbcConn = (java.sql.Connection)connObj.getRawConnection();
        return jdbcConn;
    }

    public static IConnectionProfile loadProfileFromProperties(Properties connProperties) throws OdaException {
        return Connection.loadProfileFromProperties(connProperties, null);
    }

    public static IConnectionProfile loadProfileFromProperties(Properties connProperties, Map<?, ?> appContext) throws OdaException {
        connProperties = Connection.adjustDbProfileProperties(connProperties);
        IConnectionProfile dbProfile = OdaProfileExplorer.getInstance().getProfileByName(connProperties, appContext);
        if (dbProfile != null) {
            return dbProfile;
        }
        return Connection.createTransientProfile(connProperties);
    }

    private static IConnectionProfile createTransientProfile(Properties connProperties) throws OdaException {
        Properties profileProps = PropertyAdapter.adaptToDbProfilePropertyNames(connProperties);
        return OdaProfileFactory.createTransientProfile((Properties)profileProps);
    }

    private static Properties adjustDbProfileProperties(Properties dataSourceProperties) throws OdaException {
        Properties dbProfileProps = PropertyAdapter.adaptToDbProfilePropertyNames(dataSourceProperties);
        String defnType = dbProfileProps.getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
        HashMap<String, String> appContext = new HashMap<String, String>();
        appContext.put("OdaConsumerId", defnType);
        Properties adjustedDbProfileProps = ProviderUtil.getEffectiveProperties((Properties)dbProfileProps, appContext);
        if (dbProfileProps.equals(adjustedDbProfileProps)) {
            return dataSourceProperties;
        }
        return PropertyAdapter.adaptToDataSourcePropertyNames(adjustedDbProfileProps);
    }

    @Override
    public void close() throws OdaException {
        if (this.m_dbProfile != null) {
            Connection.closeProfile(this.m_dbProfile);
            this.m_dbProfile = null;
            this.jdbcConn = null;
            return;
        }
        super.close();
    }

    protected static void close(IConnectionProfile dbProfile) {
        Connection.closeProfile(dbProfile);
    }

    public static void closeProfile(IConnectionProfile connProfile) {
        if (connProfile == null) {
            return;
        }
        if (connProfile instanceof OdaConnectionProfile) {
            ((OdaConnectionProfile)connProfile).close();
        } else {
            connProfile.disconnect(null);
        }
    }

    @Override
    public boolean isOpen() throws OdaException {
        if (this.m_dbProfile != null) {
            return this.m_dbProfile.getConnectionState() == 1;
        }
        return super.isOpen();
    }

    @Override
    public IQuery newQuery(String dataSetType) throws OdaException {
        return new DBProfileStatement(this.getRawConnection());
    }

    protected IConnectionProfile getDbProfile() {
        return this.m_dbProfile;
    }

    protected java.sql.Connection getRawConnection() {
        return this.jdbcConn;
    }

    public static Throwable getStatusException(IStatus status) {
        if (status == null) {
            return null;
        }
        Throwable ex = status.getException();
        if (ex != null) {
            return ex;
        }
        IStatus[] childrenStatus = status.getChildren();
        int i = 0;
        while (i < childrenStatus.length && ex == null) {
            ex = childrenStatus[i].getException();
            ++i;
        }
        return ex;
    }
}

