/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.script.IBaseDataSetEventHandler;
import org.eclipse.birt.data.engine.api.script.IDataRow;
import org.eclipse.birt.data.engine.api.script.IDataSetInstanceHandle;
import org.eclipse.birt.data.engine.script.JSMethodRunner;
import org.mozilla.javascript.Scriptable;

public class DataSetJSEventHandler
implements IBaseDataSetEventHandler {
    protected IBaseDataSetDesign design;
    protected JSMethodRunner runner;
    private ScriptContext cx;

    public DataSetJSEventHandler(ScriptContext cx, IBaseDataSetDesign dataSetDesign) {
        this.design = dataSetDesign;
        this.cx = cx;
    }

    protected IBaseDataSetDesign getBaseDesign() {
        return this.design;
    }

    protected JSMethodRunner getRunner(Scriptable scope) {
        if (this.runner == null) {
            String scopeName = "DataSet[" + this.design.getName() + "]";
            this.runner = new JSMethodRunner(this.cx, scope, scopeName);
        }
        return this.runner;
    }

    public void handleBeforeOpen(IDataSetInstanceHandle dataSet) throws BirtException {
        String script = this.getBaseDesign().getBeforeOpenScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSet.getScriptScope()).runScript("beforeOpen", script);
        }
    }

    public void handleBeforeClose(IDataSetInstanceHandle dataSet) throws BirtException {
        String script = this.getBaseDesign().getBeforeCloseScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSet.getScriptScope()).runScript("beforeClose", script);
        }
    }

    public void handleAfterOpen(IDataSetInstanceHandle dataSet) throws BirtException {
        String script = this.getBaseDesign().getAfterOpenScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSet.getScriptScope()).runScript("afterOpen", script);
        }
    }

    public void handleAfterClose(IDataSetInstanceHandle dataSet) throws BirtException {
        String script = this.getBaseDesign().getAfterCloseScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSet.getScriptScope()).runScript("afterClose", script);
        }
    }

    public void handleOnFetch(IDataSetInstanceHandle dataSet, IDataRow row) throws BirtException {
        String script = this.getBaseDesign().getOnFetchScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSet.getScriptScope()).runScript("onFetch", script);
        }
    }
}

