/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.document.IRandomAccessObject;
import org.eclipse.birt.data.engine.olap.data.document.IRandomDataAccessObject;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;

public class RandomDataAccessObject
implements IRandomDataAccessObject {
    IRandomAccessObject delegate;
    private static Logger logger = Logger.getLogger(RandomDataAccessObject.class.getName());

    public RandomDataAccessObject(IRandomAccessObject randomAccessObject) throws IOException {
        this.delegate = randomAccessObject;
    }

    public void setLength(long newLength) throws IOException {
        this.delegate.setLength(newLength);
    }

    public long getFilePointer() {
        try {
            return this.delegate.getFilePointer();
        }
        catch (IOException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return -1L;
        }
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public int readUnsignedByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b & 0xFF;
    }

    public byte readByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public Date readDate() throws IOException {
        return new Date(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    break;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    break;
                }
                default: {
                    input.append((char)c);
                }
            }
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    public BigDecimal readBigDecimal() throws IOException {
        String str = this.readUTF();
        return new BigDecimal(str);
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public void writeBoolean(boolean b) throws IOException {
        this.write(b ? 1 : 0);
    }

    public void writeByte(int b) throws IOException {
        this.write(b);
    }

    public void writeShort(int s) throws IOException {
        this.write(s >>> 8 & 0xFF);
        this.write(s >>> 0 & 0xFF);
    }

    public void writeChar(int ch) throws IOException {
        this.writeShort(ch);
    }

    public void writeInt(int i) throws IOException {
        this.write(i >>> 24 & 0xFF);
        this.write(i >>> 16 & 0xFF);
        this.write(i >>> 8 & 0xFF);
        this.write(i >>> 0 & 0xFF);
    }

    public void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)(l >>> 0) & 0xFF);
    }

    public void writeDate(Date date) throws IOException {
        this.writeLong(date.getTime());
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double f) throws IOException {
        this.writeLong(Double.doubleToLongBits(f));
    }

    public void writeBigDecimal(BigDecimal bigDecimal) throws IOException {
        this.writeUTF(bigDecimal.toString());
    }

    public void writeUTF(String str) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        int i = 0;
        while (i < strlen) {
            c = str.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(utflen >>> 8 & 0xFF);
        this.write(utflen >>> 0 & 0xFF);
        i = 0;
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
            } else if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c >> 0 & 0x3F);
            } else {
                this.write(0xC0 | c >> 6 & 0x1F);
                this.write(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int pos, int len) throws IOException {
        int n = 0;
        while (n < len) {
            int count = this.read(b, pos + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }

    public void writeBytes(String s) throws IOException {
        byte[] b = s.getBytes();
        this.write(b, 0, b.length);
    }

    public void writeChars(String s) throws IOException {
        int clen = s.length();
        int blen = 2 * clen;
        byte[] b = new byte[blen];
        char[] c = new char[clen];
        s.getChars(0, clen, c, 0);
        int i = 0;
        int j = 0;
        while (i < clen) {
            b[j++] = (byte)(c[i] >>> 8);
            b[j++] = (byte)(c[i] >>> 0);
            ++i;
        }
        this.write(b, 0, blen);
    }

    public long length() throws IOException {
        return this.delegate.length();
    }

    public int read() throws IOException {
        return this.delegate.read();
    }

    public Bytes readBytes() throws IOException {
        int readSize;
        int size = this.readInt();
        byte[] b = new byte[size];
        int totalReadSize = 0;
        totalReadSize = readSize = this.read(b, 0, b.length);
        while (readSize != -1 && totalReadSize < size) {
            readSize = this.read(b, totalReadSize, size - totalReadSize);
            if (readSize == -1) continue;
            totalReadSize += readSize;
        }
        return new Bytes(b);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int pos, int len) throws IOException {
        return this.delegate.read(b, pos, len);
    }

    public void seek(long pos) throws IOException {
        this.delegate.seek(pos);
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skipBytes((long)n);
    }

    public long skipBytes(long n) throws IOException {
        try {
            this.delegate.seek(this.getFilePointer() + n);
            return n;
        }
        catch (EOFException eOFException) {
            return -1L;
        }
    }

    public void writeBytes(Bytes b) throws IOException {
        this.writeInt(b.bytesValue().length);
        this.write(b.bytesValue(), 0, b.bytesValue().length);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int pos, int len) throws IOException {
        this.delegate.write(b, pos, len);
    }

    public void write(int b) throws IOException {
        byte[] bA = new byte[]{(byte)b};
        this.delegate.write(bA, 0, 1);
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.delegate.close();
    }

    public Object readObject() throws IOException {
        return null;
    }

    public void writeObject(Object o) throws IOException {
    }
}

