/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBaseTransform;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.IPreparedQueryService;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedQueryUtil;
import org.eclipse.birt.data.engine.impl.PreparedSubquery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.ServiceForQueryResults;
import org.eclipse.birt.data.engine.impl.SubqueryDefinitionCopyUtil;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Scriptable;

public final class PreparedQuery {
    private IBaseQueryDefinition baseQueryDefn;
    private DataEngineContext dataEngineContext;
    private DataEngineSession session;
    private ExpressionCompiler expressionCompiler;
    private IPreparedQueryService queryService;
    private AggregateTable aggrTable;
    private Map appContext;
    private HashMap subQueryMap;
    private HashMap subQueryDefnMap;
    private static Logger logger = Logger.getLogger(DataEngineImpl.class.getName());
    private ExprManager exprManager;

    PreparedQuery(DataEngineSession session, DataEngineContext deContext, IBaseQueryDefinition queryDefn, IPreparedQueryService queryService, Map appContext) throws DataException {
        logger.logp(Level.FINER, PreparedQuery.class.getName(), "PreparedQuery", "PreparedQuery starts up.");
        assert (queryDefn != null);
        this.expressionCompiler = new ExpressionCompiler();
        this.expressionCompiler.setDataSetMode(false);
        this.dataEngineContext = deContext;
        this.session = session;
        this.baseQueryDefn = queryDefn instanceof SubqueryDefinition ? SubqueryDefinitionCopyUtil.createSubqueryDefinition(((SubqueryDefinition)queryDefn).getName(), (ISubqueryDefinition)queryDefn) : queryDefn;
        this.queryService = queryService;
        this.appContext = appContext;
        this.exprManager = new ExprManager(this.baseQueryDefn, session.getEngineContext().getScriptContext());
        this.subQueryMap = new HashMap();
        this.subQueryDefnMap = new HashMap();
        this.aggrTable = new AggregateTable(this.session.getTempDir(), this.session.getSharedScope(), this.baseQueryDefn.getGroups());
        logger.fine("Start to prepare a PreparedQuery.");
        this.prepare();
        logger.fine("Finished preparing the PreparedQuery.");
    }

    private void prepare() throws DataException {
        if (this.baseQueryDefn.getBindings() != null && this.baseQueryDefn.getBindings().size() > 0) {
            this.expressionCompiler.setDataSetMode(false);
        }
        List groups = this.baseQueryDefn.getGroups();
        HashSet<String> groupNameSet = new HashSet<String>();
        int i = 0;
        while (i < groups.size()) {
            IGroupDefinition group = (IGroupDefinition)groups.get(i);
            if (group.getName() != null && group.getName().trim().length() != 0) {
                int j = 0;
                while (j < groups.size()) {
                    if (group.getName().equals(((IGroupDefinition)groups.get(j)).getName() == null ? "" : ((IGroupDefinition)groups.get(j)).getName()) && j != i) {
                        throw new DataException("data.engine.DuplicateGroupName");
                    }
                    ++j;
                }
                groupNameSet.add(group.getName());
            }
            ++i;
        }
        Map map = this.baseQueryDefn.getBindings();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                IBinding binding = (IBinding)entry.getValue();
                String groupName = null;
                if (binding.getExpression() != null) {
                    groupName = binding.getExpression().getGroupName();
                }
                if (groupName == null) {
                    if (binding.getAggregatOns().size() == 0) continue;
                    groupName = binding.getAggregatOns().get(0).toString();
                }
                if (groupName.equals("Total.OVERALL") || groupNameSet.contains(groupName)) continue;
                throw new DataException("data.engine.GroupNotExist", new Object[]{groupName, key});
            }
        }
        PreparedQueryUtil.mappingParentColumnBinding(this.baseQueryDefn);
        int i2 = 0;
        while (i2 <= groups.size()) {
            this.prepareGroup(this.baseQueryDefn, i2, this.dataEngineContext.getScriptContext());
            ++i2;
        }
    }

    private void prepareGroup(IBaseQueryDefinition baseQuery, int groupLevel, ScriptContext cx) throws DataException {
        IBaseTransform trans = baseQuery;
        String groupName = "Total.OVERALL";
        if (groupLevel != 0) {
            IGroupDefinition igd = (IGroupDefinition)trans.getGroups().get(groupLevel - 1);
            trans = igd;
            groupName = igd.getName();
        }
        ArrayList<IBaseExpression> exprCol = new ArrayList<IBaseExpression>();
        HashMap resultSetExpressions = new HashMap();
        Map map = baseQuery.getBindings();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                IBinding icbe = (IBinding)entry.getValue();
                if (icbe.getExpression() != null && icbe.getExpression().getGroupName().equals(groupName) && groupLevel != 0) {
                    exprCol.add(icbe.getExpression());
                    resultSetExpressions.put(entry.getKey(), icbe);
                    continue;
                }
                if (groupLevel == 0 && icbe.getAggregatOns().size() == 0) {
                    exprCol.add(icbe.getExpression());
                    resultSetExpressions.put(entry.getKey(), icbe);
                    continue;
                }
                if (groupLevel == 0 || !icbe.getAggregatOns().contains(groupName)) continue;
                exprCol.add(icbe.getExpression());
                resultSetExpressions.put(entry.getKey(), icbe);
            }
        }
        this.prepareExpressions(exprCol, groupLevel, false, true, cx);
        String key = null;
        if (trans instanceof IGroupDefinition) {
            IGroupDefinition gd = (IGroupDefinition)trans;
            key = gd.getKeyColumn() != null ? gd.getKeyColumn() : gd.getKeyExpression();
        }
        this.exprManager.addBindingExpr(key, resultSetExpressions, groupLevel);
        Collection subQueries = trans.getSubqueries();
        for (ISubqueryDefinition subquery : subQueries) {
            PreparedSubquery pq = new PreparedSubquery(this.session, this.dataEngineContext, subquery, this.queryService, groupLevel);
            this.subQueryMap.put(subquery.getName(), pq);
            this.subQueryDefnMap.put(subquery.getName(), new Object[]{subquery, groupLevel});
        }
    }

    private void prepareExpressions(Collection expressions, int groupLevel, boolean afterGroup, boolean isDetailedRow, ScriptContext cx) throws DataException {
        if (expressions == null) {
            return;
        }
        AggregateRegistry reg = this.aggrTable.getAggrRegistry(groupLevel, -1, isDetailedRow, cx);
        Iterator it = expressions.iterator();
        while (it.hasNext()) {
            this.prepareExpression((IBaseExpression)it.next(), groupLevel, cx, reg);
        }
    }

    private void prepareExpression(IBaseExpression expr, int groupLevel, ScriptContext cx, AggregateRegistry reg) throws DataException {
        try {
            ExpressionCompiler compiler = this.expressionCompiler;
            if (expr instanceof IScriptExpression) {
                IScriptExpression cfr_ignored_0 = (IScriptExpression)expr;
                String exprText = ((IScriptExpression)expr).getText();
                CompiledExpression handle = compiler.compile(exprText, reg, this.session.getEngineContext().getScriptContext());
                expr.setHandle(handle);
            } else if (expr instanceof IConditionalExpression) {
                IConditionalExpression ce = (IConditionalExpression)expr;
                ce = this.transformConditionalExpression(ce);
                this.prepareExpression(ce.getExpression(), groupLevel, cx, reg);
                if (ce.getOperand1() != null) {
                    this.prepareExpression(ce.getOperand1(), groupLevel, cx, reg);
                }
                if (ce.getOperand2() != null) {
                    this.prepareExpression(ce.getOperand2(), groupLevel, cx, reg);
                }
                expr.setHandle(ce);
            } else if (expr instanceof IExpressionCollection) {
                IExpressionCollection ce = (IExpressionCollection)expr;
                Object[] exprs = ce.getExpressions().toArray();
                int i = 0;
                while (i < exprs.length) {
                    this.prepareExpression((IBaseExpression)exprs[i], groupLevel, cx, reg);
                    ++i;
                }
            }
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private IConditionalExpression transformConditionalExpression(IConditionalExpression ce) {
        String prefix = null;
        switch (ce.getOperator()) {
            case 14: {
                prefix = "Total.isTopN";
                break;
            }
            case 16: {
                prefix = "Total.isTopNPercent";
                break;
            }
            case 15: {
                prefix = "Total.isBottomN";
                break;
            }
            case 17: {
                prefix = "Total.isBottomNPercent";
            }
        }
        if (prefix != null) {
            ce = new ConditionalExpression(String.valueOf(prefix) + "(" + ce.getExpression().getText() + "," + ((IScriptExpression)ce.getOperand1()).getText() + ")", 11);
        }
        return ce;
    }

    public QueryResults doPrepare(IBaseQueryResults outerResults, Scriptable scope, QueryExecutor executor, PreparedDataSourceQuery dataSourceQuery) throws DataException {
        if (this.baseQueryDefn == null) {
            DataException e = new DataException("data.engine.PreparedQueryClosed");
            logger.logp(Level.WARNING, PreparedQuery.class.getName(), "doPrepare", "PreparedQuery instance is closed.", e);
            throw e;
        }
        executor.setAppContext(this.appContext);
        logger.finer("Start to prepare the execution.");
        executor.prepareExecution(outerResults, scope);
        logger.finer("Finish preparing the execution.");
        QueryResults result = new QueryResults(new ServiceForQueryResults(this.session, executor.getQueryScope(), executor.getNestedLevel() + 1, dataSourceQuery, this.queryService, executor, this.baseQueryDefn, this.exprManager));
        if (this.baseQueryDefn.cacheQueryResults() && this.baseQueryDefn instanceof IQueryDefinition) {
            result.setID(this.session.getQueryResultIDUtil().nextID());
            ((QueryDefinition)this.baseQueryDefn).setQueryResultsID(result.getID());
        }
        return result;
    }

    ISubqueryDefinition getSubQueryDefn(String subQueryName) {
        return (ISubqueryDefinition)((Object[])this.subQueryDefnMap.get(subQueryName))[0];
    }

    int getSubQueryLevel(String subQueryName) {
        return (Integer)((Object[])this.subQueryDefnMap.get(subQueryName))[1];
    }

    QueryResults execSubquery(IResultIterator iterator, IQueryExecutor executor, String subQueryName, Scriptable subScope) throws DataException {
        assert (subQueryName != null);
        PreparedSubquery subquery = (PreparedSubquery)this.subQueryMap.get(subQueryName);
        if (subquery == null) {
            DataException e = new DataException("data.engine.NoSubQueryName", subQueryName);
            logger.logp(Level.FINE, PreparedQuery.class.getName(), "execSubquery", "Subquery name not found", e);
            throw e;
        }
        return subquery.execute(iterator, executor, subScope);
    }

    void close() {
        this.baseQueryDefn = null;
        this.aggrTable = null;
        this.subQueryMap = null;
        logger.logp(Level.FINER, PreparedQuery.class.getName(), "close", "Prepared query closed");
    }

    Scriptable getSharedScope() {
        return this.session.getSharedScope();
    }

    IBaseQueryDefinition getBaseQueryDefn() {
        return this.baseQueryDefn;
    }

    AggregateTable getAggrTable() {
        return this.aggrTable;
    }
}

