/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.util.List;
import org.eclipse.birt.data.engine.cache.BasicCachedList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.group.AggrValuesUpdator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupRange;
import org.eclipse.birt.data.engine.executor.transform.group.RuntimeGroupInfo;
import org.eclipse.birt.data.engine.impl.DataEngineSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupInfoUpdator {
    private int level;
    protected AggrValuesUpdator[] aggrUpdator;
    protected List<GroupInfo> originGroups;
    protected List<GroupInfo> newGroups;
    protected int parentIdxAdj;
    protected int childIdxAdj;
    protected RuntimeGroupInfo currentGroup;
    protected int lastIndex;

    public GroupInfoUpdator(int level, String tempDir, List<GroupInfo> groups, int last, AggrValuesUpdator[] aggrValues) {
        this.level = level;
        this.originGroups = groups;
        this.lastIndex = last;
        this.newGroups = new BasicCachedList(tempDir, DataEngineSession.getCurrentClassLoader());
        this.aggrUpdator = aggrValues;
    }

    public void onGroup(int groupIndex) throws DataException {
        this.acceptPrevious(groupIndex);
        if (this.currentGroup == null) {
            this.currentGroup = this.getRumtimeGroupInfo(groupIndex);
        }
    }

    protected void acceptPrevious(int groupIndex) throws DataException {
        if (this.currentGroup == null) {
            return;
        }
        if (this.currentGroup.groupId < groupIndex) {
            if (!this.currentGroup.isRemoved()) {
                this.acceptGroup(this.currentGroup);
            }
            this.currentGroup = null;
        } else if (this.currentGroup.groupId > groupIndex) {
            throw new DataException("data.engine.groupIncrementalUpdate.IllegalGroupOrderState", new Object[]{this.currentGroup.groupId, groupIndex});
        }
    }

    public int notOnGroup(int groupIndex) throws DataException {
        this.acceptPrevious(groupIndex);
        if (this.currentGroup == null) {
            this.currentGroup = this.getRumtimeGroupInfo(groupIndex);
        }
        int rIdx = -1;
        ++this.currentGroup.removed;
        ++this.childIdxAdj;
        if (this.currentGroup.isRemoved()) {
            rIdx = groupIndex;
        }
        return rIdx;
    }

    protected RuntimeGroupInfo getRumtimeGroupInfo(int index) {
        GroupInfo current = this.getGroupInfo(index);
        GroupInfo next = this.getGroupInfo(index + 1);
        int count = next != null ? next.firstChild - current.firstChild : this.lastIndex - current.firstChild + 1;
        return new RuntimeGroupInfo(current, index, count, this.parentIdxAdj, this.childIdxAdj);
    }

    protected GroupInfo getGroupInfo(int index) {
        if (index < this.originGroups.size()) {
            return this.originGroups.get(index);
        }
        return null;
    }

    protected void acceptGroup(RuntimeGroupInfo groupInfo) {
        GroupInfo grpInfo = new GroupInfo();
        grpInfo.parent = groupInfo.group.parent - groupInfo.parentIdxAdj;
        grpInfo.firstChild = groupInfo.group.firstChild - groupInfo.childIdxAdj;
        this.newGroups.add(grpInfo);
        this.acceptAggr(groupInfo.groupId);
    }

    protected void acceptAggr(int groupIndex) {
        int i = 0;
        while (this.aggrUpdator != null && i < this.aggrUpdator.length) {
            this.aggrUpdator[i].onGroup(this.level + 1, groupIndex);
            ++i;
        }
    }

    public void increaseParentIndex() {
        ++this.parentIdxAdj;
    }

    public List<GroupInfo> getGroups() {
        return this.newGroups;
    }

    public void close() {
        if (this.currentGroup != null && !this.currentGroup.isRemoved()) {
            this.acceptGroup(this.currentGroup);
        }
    }

    public int filterGroup(int groupIndex) throws DataException {
        this.acceptPrevious(groupIndex);
        if (this.currentGroup == null) {
            this.currentGroup = this.getRumtimeGroupInfo(groupIndex);
        }
        this.currentGroup.removed += this.currentGroup.count;
        this.childIdxAdj += this.currentGroup.count;
        assert (this.currentGroup.isRemoved());
        return this.currentGroup.count;
    }

    public GroupRange filterGroupRange(GroupRange range) throws DataException {
        GroupRange childRange = new GroupRange();
        int i = range.first;
        while (i < range.length + range.first) {
            RuntimeGroupInfo currentGroup = this.getRumtimeGroupInfo(i);
            if (i == range.first) {
                this.acceptPrevious(i);
                childRange.first = currentGroup.group.firstChild;
            }
            childRange.length += currentGroup.count;
            ++i;
        }
        this.childIdxAdj += childRange.length;
        return childRange;
    }

    public GroupRange acceptGroupRange(GroupRange range) throws DataException {
        GroupRange childRange = new GroupRange();
        int i = range.first;
        while (i < range.length + range.first) {
            RuntimeGroupInfo currentGroup = this.getRumtimeGroupInfo(i);
            if (i == range.first) {
                this.acceptPrevious(i);
                childRange.first = currentGroup.group.firstChild;
            }
            childRange.length += currentGroup.count;
            this.acceptGroup(currentGroup);
            ++i;
        }
        return childRange;
    }

    public GroupRange getChildRange() {
        if (this.currentGroup == null) {
            return null;
        }
        return new GroupRange(this.currentGroup.group.firstChild, this.currentGroup.count);
    }

    public void increaseChildIndex(int childs) {
        this.childIdxAdj += childs;
        if (this.currentGroup != null) {
            this.currentGroup.removed += childs;
        }
    }

    public void increaseParentIndex(int parents) {
        this.parentIdxAdj += parents;
    }

    public int getChildCount(int groupIdx) {
        int count = 0;
        GroupInfo i = this.getGroupInfo(groupIdx);
        if (i == null) {
            return count;
        }
        GroupInfo next = this.getGroupInfo(groupIdx + 1);
        count = next != null ? next.firstChild - i.firstChild : this.lastIndex - i.firstChild + 1;
        return count;
    }
}

