/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemPresentationBase;
import org.eclipse.birt.chart.reportitem.ChartReportItemPresentationPlotImpl;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.Size;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.IReportItem;

public final class ChartReportItemPresentationAxisImpl
extends ChartReportItemPresentationBase {
    private static IDataRowExpressionEvaluator DUMMY_AXIS_CHART_EVALUATOR = new IDataRowExpressionEvaluator(){

        public void close() {
        }

        public Object evaluate(String expression) {
            return null;
        }

        public Object evaluateGlobal(String expression) {
            return null;
        }

        public boolean first() {
            return true;
        }

        public boolean next() {
            return false;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModelObject(ExtendedItemHandle eih) {
        this.modelHandle = (ExtendedItemHandle)eih.getElementProperty("hostChart");
        IReportItem item = this.getReportItem(this.modelHandle);
        if (item == null) {
            return;
        }
        this.cm = (Chart)((ChartReportItemImpl)item).getProperty("chart.instance");
        IReportItem iReportItem = item;
        synchronized (iReportItem) {
            if (this.cm != null) {
                this.cm = this.cm.copyInstance();
            }
        }
        this.setChartModelObject(item);
    }

    protected Bounds computeBounds() throws ChartException {
        Bounds originalBounds = this.cm.getBlock().getBounds();
        Bounds bounds = originalBounds.copyInstance();
        if (this.cm instanceof ChartWithAxes) {
            try {
                ChartWithAxes chart = (ChartWithAxes)this.cm;
                AggregationCellHandle xtabCell = ChartCubeUtil.getXtabContainerCell(this.modelHandle);
                if (chart.isTransposed()) {
                    bounds.setHeight(0.0);
                    double dWidth = ChartReportItemPresentationPlotImpl.getColumnCellWidth(xtabCell.getCrosstab(), this.renderDpi);
                    if (!ChartUtil.mathEqual(dWidth, 0.0) && !ChartUtil.mathEqual(dWidth, ChartCubeUtil.DEFAULT_COLUMN_WIDTH.getMeasure())) {
                        bounds.setWidth(dWidth);
                    } else if (!bounds.isSetWidth() || ChartUtil.mathEqual(bounds.getWidth(), 0.0)) {
                        bounds.setWidth(ChartCubeUtil.DEFAULT_COLUMN_WIDTH.getMeasure());
                    }
                } else {
                    bounds.setWidth(0.0);
                    double dHeight = ChartReportItemPresentationPlotImpl.getRowCellHeight(xtabCell.getCrosstab(), this.renderDpi);
                    if (!ChartUtil.mathEqual(dHeight, 0.0) && !ChartUtil.mathEqual(dHeight, ChartCubeUtil.DEFAULT_ROW_HEIGHT.getMeasure())) {
                        bounds.setHeight(dHeight);
                    } else if (!bounds.isSetHeight() || ChartUtil.mathEqual(bounds.getHeight(), 0.0)) {
                        bounds.setHeight(ChartCubeUtil.DEFAULT_ROW_HEIGHT.getMeasure());
                    }
                }
            }
            catch (BirtException e) {
                throw new ChartException("org.eclipse.birt.chart.reportitem", 3, (Throwable)e);
            }
        }
        return bounds;
    }

    protected void updateChartModel() {
        super.updateChartModel();
        ChartCubeUtil.updateModelToRenderAxis(this.cm, this.rtc.isRightToLeft());
    }

    protected IDataRowExpressionEvaluator createEvaluator(IBaseResultSet set) throws ChartException {
        return DUMMY_AXIS_CHART_EVALUATOR;
    }

    public Size getSize() {
        Size sz = super.getSize();
        if ("SVG".equalsIgnoreCase(this.sExtension)) {
            sz.setWidth(sz.getWidth() + 10.0f);
        }
        return sz;
    }

    protected void prepareDeviceRenderer() throws ChartException {
        super.prepareDeviceRenderer();
        if ("SVG".equalsIgnoreCase(this.sExtension)) {
            this.idr.setProperty("resize.svg", Boolean.FALSE);
        }
    }
}

