/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.data.dte.DocumentDataSource;
import org.eclipse.birt.report.engine.emitter.DOMBuilderEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.MasterPageExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutorUtil;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.executor.ReportletItemExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.toc.TOCBuilder;

public class ReportExecutor
implements IReportExecutor {
    protected ExecutionContext context;
    protected ExecutorManager manager;
    protected Report report;
    protected ReportContent reportContent;
    protected long uniqueId;
    protected HashMap pages = new HashMap();
    protected ReportletItemExecutor reportletExecutor;
    int currentItem;

    public ReportExecutor(ExecutionContext context) {
        this.context = context;
        this.report = context.getReport();
        this.manager = new ExecutorManager(this);
        this.uniqueId = 0L;
    }

    public IReportContent execute() throws BirtException {
        long reportletId;
        this.reportContent = new ReportContent(this.report);
        this.reportContent.setExecutionContext(this.context);
        this.context.setReportContent(this.reportContent);
        try {
            TOCBuilder tocBuilder = new TOCBuilder(this.context);
            this.reportContent.setTOCTree(tocBuilder.getTOCTree());
            this.context.setTOCBuilder(tocBuilder);
        }
        catch (IOException ex) {
            this.context.addException(new EngineException("Error.FailedToCreateTOC", ex));
        }
        DocumentDataSource dataSource = this.context.getDataSource();
        if (dataSource != null && (reportletId = dataSource.getElementID()) != -1L) {
            this.reportletExecutor = new ReportletItemExecutor(this.manager);
        }
        Map appContext = this.context.getAppContext();
        this.context.getDataEngine().prepare(this.report, appContext);
        if (this.reportletExecutor == null) {
            this.context.optimizeExecution();
        }
        this.currentItem = 0;
        if (this.reportletExecutor != null) {
            this.reportletExecutor.execute();
        }
        return this.reportContent;
    }

    public void close() throws BirtException {
        block7: {
            TOCBuilder builder = this.context.getTOCBuilder();
            if (builder != null) {
                try {
                    try {
                        builder.close();
                    }
                    catch (IOException ex) {
                        this.context.addException(new EngineException("failed to close TOC", ex));
                        this.context.setTOCBuilder(null);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.context.setTOCBuilder(null);
                    throw throwable;
                }
                this.context.setTOCBuilder(null);
            }
        }
        if (this.reportletExecutor != null) {
            this.reportletExecutor.close();
            this.reportletExecutor = null;
        }
        this.uniqueId = 0L;
    }

    public IReportItemExecutor getNextChild() {
        if (this.reportletExecutor != null) {
            return this.reportletExecutor.getNextChild();
        }
        if (this.currentItem < this.report.getContentCount()) {
            ReportItemDesign design = this.report.getContent(this.currentItem++);
            ReportItemExecutor executor = this.manager.createExecutor(null, design);
            return executor;
        }
        return null;
    }

    public boolean hasNextChild() {
        if (this.reportletExecutor != null) {
            return this.reportletExecutor.hasNextChild();
        }
        return this.currentItem < this.report.getContentCount();
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    public ExecutorManager getManager() {
        return this.manager;
    }

    long generateUniqueID() {
        return this.uniqueId++;
    }

    public IReportItemExecutor createPageExecutor(long pageNumber, MasterPageDesign pageDesign) throws BirtException {
        IPageContent pageContent = (IPageContent)this.pages.get(pageDesign);
        if (pageContent == null) {
            MasterPageExecutor pageExecutor = new MasterPageExecutor(this.manager, pageNumber, pageDesign);
            pageContent = (IPageContent)pageExecutor.execute();
            DOMBuilderEmitter domEmitter = new DOMBuilderEmitter(pageContent);
            ReportExecutorUtil.executeAll(pageExecutor, domEmitter);
            pageExecutor.close();
            this.pages.put(pageDesign, pageContent);
        } else {
            pageContent.setPageNumber(pageNumber);
            this.context.setPageNumber(pageNumber);
        }
        return new DOMReportItemExecutor(pageContent, true);
    }
}

