/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build.framework;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.build.framework.Bundle;
import org.eclipse.birt.build.framework.BundleEntry;
import org.eclipse.birt.build.framework.BundleFile;
import org.eclipse.birt.build.framework.FileBundleEntry;

public class FileBundleFile
extends BundleFile {
    public FileBundleFile(Bundle bundle, File basefile) throws IOException {
        super(bundle, basefile);
    }

    @Override
    public BundleEntry getEntry(String path) {
        File file = new File(this.basefile, path = this.normalizeFile(path));
        if (!file.exists()) {
            return null;
        }
        return new FileBundleEntry(this, file, path);
    }

    @Override
    public boolean isDirectory(String path) {
        File dirPath = new File(this.basefile, path = this.normalizeFolder(path));
        return dirPath.exists() && dirPath.isDirectory();
    }

    @Override
    public List<String> getEntryPaths(String path) {
        File pathFile = new File(this.basefile, path = this.normalizeFolder(path));
        if (pathFile.exists() && pathFile.isDirectory()) {
            String[] fileList = pathFile.list();
            if (fileList == null || fileList.length == 0) {
                return null;
            }
            ArrayList<String> entries = new ArrayList<String>();
            String[] stringArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File childFile = new File(pathFile, file);
                StringBuffer sb = new StringBuffer(path).append(file);
                if (childFile.isDirectory()) {
                    sb.append("/");
                }
                entries.add(sb.toString());
                ++n2;
            }
            return entries;
        }
        return null;
    }

    @Override
    public void close() {
    }
}

