/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build.framework;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.build.framework.BundleFile;

public abstract class BundleEntry {
    protected BundleFile bundleFile;
    protected String name;

    public abstract InputStream getInputStream() throws IOException;

    public abstract int getSize();

    public abstract long getTime();

    public BundleFile getBundleFile() {
        return this.bundleFile;
    }

    public String getName() {
        return this.name;
    }

    BundleEntry(BundleFile bundleFile, String name) {
        this.bundleFile = bundleFile;
        this.name = name;
    }

    public String getBundleID() {
        if (this.bundleFile != null && this.bundleFile.getBundle() != null) {
            return this.bundleFile.getBundle().getBundleID();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public byte[] getBytes() throws IOException {
        InputStream in = this.getInputStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
                byte[] buffer = new byte[4096];
                int size = in.read(buffer);
                while (size > 0) {
                    out.write(buffer, 0, size);
                    size = in.read(buffer);
                }
                return out.toByteArray();
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

