/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class ReliableTask
extends Task
implements TaskContainer {
    private Vector nestedTasks = new Vector();
    protected int retrial = 1;
    protected String failProperty = "isfail";
    protected boolean failOnError = false;
    protected int interval = 0;

    public void setRetrial(int retrial) {
        this.retrial = retrial;
    }

    public void setFailProperty(String property) {
        this.failProperty = property;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setFailOnError(boolean f) {
        this.failOnError = f;
    }

    public void addTask(Task nestedTask) {
        this.nestedTasks.addElement(nestedTask);
    }

    public void execute() throws BuildException {
        boolean pass = false;
        int count = 0;
        while (count < this.retrial && !pass) {
            try {
                Enumeration e = this.nestedTasks.elements();
                while (e.hasMoreElements()) {
                    Task nestedTask = (Task)e.nextElement();
                    nestedTask.perform();
                }
                pass = true;
            }
            catch (BuildException e) {
                ++count;
                pass = false;
                this.log("excute reliableTask failed one time!", 2);
                try {
                    Thread.sleep(this.interval);
                }
                catch (Exception ee) {
                    this.log(ee.getMessage(), 1);
                }
            }
        }
        if (!pass) {
            if (this.failOnError) {
                throw new BuildException("reliable task failed after retry " + this.retrial + " times!");
            }
            this.getProject().setProperty(this.failProperty, "true");
            this.log("reliable task failed after retry " + this.retrial + " times!", 1);
        }
    }
}

