/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.birt.build.PrefixFileFilter;

public class GenCaseResult {
    private static File ResultFile = null;
    private static String PluginName = null;
    private static String TotalCase = null;
    private static String FailCase = null;
    private static String ErrorCase = null;
    private static boolean compileError = false;
    private static String performancePath = null;
    private File ReportPath = null;
    private String TotalRpt = null;
    private String SameRpt = null;
    private String DiffRpt = null;
    private static String CONSTANT_RED = "#FF0000";
    private static String CONSTANT_BLACK = "#000000";
    private static String CONSTANT_BOLD = "font-weight:700";
    private static String CONSTANT_NORMAL = "font-weight:100";
    private DOMElement rootElement = new DOMElement("TestSuiteReport");

    public File getReportPath(String testReport) {
        this.ReportPath = new File(testReport);
        return this.ReportPath;
    }

    public void setPerformancePath(String path) {
        performancePath = path;
    }

    public static void getResultFile(String testResultPath) {
        ResultFile = new File(testResultPath);
        if (!ResultFile.exists()) {
            compileError = true;
            PluginName = ResultFile.getName();
            TotalCase = "N/A";
            FailCase = "N/A";
            ErrorCase = "N/A";
        } else {
            compileError = false;
        }
    }

    public static void main(String[] args) {
        int i = 0;
        GenCaseResult report = new GenCaseResult();
        i = 1;
        while (i < args.length) {
            System.out.println(args[i]);
            String param = args[i];
            if (param.startsWith("--") && param.endsWith("performance")) {
                report.setPerformancePath(args[++i]);
                report.wrtTestReport("performance");
            } else if (param.startsWith("--") && param.endsWith("smoketest")) {
                report.setPerformancePath(args[++i]);
                GenCaseResult.getResultFile(args[i]);
                report.parseSmokeTestResult();
                report.wrtTestReport("engine." + args[i]);
            } else {
                GenCaseResult.getResultFile(args[i]);
                report.getTestResult();
                report.wrtTestReport("autotest");
            }
            ++i;
        }
        report.genReport(args[0]);
    }

    private void genReport(String path) {
        DOMElement testElement = new DOMElement("ReportDate");
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat currentDate = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = currentDate.format(cal.getTime());
        testElement.setText(strDate);
        this.rootElement.add((Element)testElement);
        DocumentFactory factory = new DocumentFactory();
        Document doc = factory.createDocument((Element)this.rootElement);
        OutputFormat format = OutputFormat.createPrettyPrint();
        try {
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(this.getReportPath(path)), format);
            writer.write(doc);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void getTestResult() {
        if (!compileError) {
            SAXReader saxReader = new SAXReader();
            Document document = null;
            try {
                document = saxReader.read(ResultFile);
            }
            catch (DocumentException dex) {
                dex.printStackTrace();
            }
            Element rootElement = document.getRootElement();
            PluginName = rootElement.attributeValue("name");
            TotalCase = rootElement.attributeValue("tests");
            FailCase = rootElement.attributeValue("failures");
            ErrorCase = rootElement.attributeValue("errors");
            System.out.println(PluginName);
            System.out.println(TotalCase);
            System.out.println(FailCase);
            System.out.println(ErrorCase);
        } else {
            System.out.println("Compile Error: " + PluginName);
            System.out.println("Compile Error: " + TotalCase);
            System.out.println("Compile Error: " + FailCase);
            System.out.println("Compile Error: " + ErrorCase);
        }
    }

    private void parseSmokeTestResult() {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(ResultFile);
        }
        catch (DocumentException dex) {
            dex.printStackTrace();
        }
        Element rootElement = document.getRootElement();
        Iterator it = rootElement.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String SumName = element.getName();
            if (!SumName.equalsIgnoreCase("sum")) continue;
            Iterator ittmp = element.elementIterator();
            while (ittmp.hasNext()) {
                Element keyelement = (Element)ittmp.next();
                String keyName = keyelement.getName();
                if (keyName.equalsIgnoreCase("same")) {
                    this.SameRpt = keyelement.getText();
                    continue;
                }
                if (!keyName.equalsIgnoreCase("differ")) continue;
                this.DiffRpt = keyelement.getText();
            }
        }
        int totalRpt = Integer.parseInt(this.SameRpt.trim());
        this.TotalRpt = Integer.toString(totalRpt += Integer.parseInt(this.DiffRpt.trim()));
        System.out.println("Engine Smoke Total:" + this.TotalRpt);
        System.out.println("Engine Smoke Same" + this.SameRpt);
        System.out.println("Engine Smoke Diff" + this.DiffRpt);
    }

    public static String getPerformanceFilePath(String folder) {
        File file = new File(folder);
        File[] files = file.listFiles(new PrefixFileFilter("reporting_2006"));
        if (files.length == 0) {
            compileError = true;
            System.out.println("Performance no file");
            return "http://www.actuate.com";
        }
        compileError = false;
        return files[0].toString();
    }

    private void wrtTestReport(String reportType) {
        try {
            if (reportType.equalsIgnoreCase("autotest")) {
                DOMElement testElement = new DOMElement("TestPlugin");
                String testSuitePlugin = PluginName.replace(".AllTests", "");
                testElement.setAttribute("id", testSuitePlugin);
                testElement.setAttribute("total", TotalCase);
                DOMElement detailElement = new DOMElement("fail");
                detailElement.setText(FailCase);
                if (FailCase != "N/A" && Integer.parseInt(FailCase.trim()) > 0) {
                    detailElement.setAttribute("color", CONSTANT_RED);
                    detailElement.setAttribute("boldStyle", CONSTANT_BOLD);
                } else {
                    detailElement.setAttribute("color", CONSTANT_BLACK);
                    detailElement.setAttribute("boldStyle", CONSTANT_NORMAL);
                }
                testElement.add((Element)detailElement);
                detailElement = new DOMElement("error");
                detailElement.setText(ErrorCase);
                if (FailCase != "N/A" && Integer.parseInt(ErrorCase.trim()) > 0) {
                    detailElement.setAttribute("color", CONSTANT_RED);
                    detailElement.setAttribute("boldStyle", CONSTANT_BOLD);
                } else {
                    detailElement.setAttribute("color", CONSTANT_BLACK);
                    detailElement.setAttribute("boldStyle", CONSTANT_NORMAL);
                }
                testElement.add((Element)detailElement);
                detailElement = new DOMElement("compileStatus");
                if (compileError) {
                    detailElement.setText("Fail");
                    detailElement.setAttribute("color", CONSTANT_RED);
                    detailElement.setAttribute("boldStyle", CONSTANT_BOLD);
                } else {
                    detailElement.setText("Pass");
                    detailElement.setAttribute("color", CONSTANT_BLACK);
                    detailElement.setAttribute("boldStyle", CONSTANT_NORMAL);
                }
                testElement.add((Element)detailElement);
                this.rootElement.add((Element)testElement);
            } else if (reportType.equalsIgnoreCase("performance")) {
                DOMElement testElement = new DOMElement("Performance");
                testElement.setAttribute("id", "org.eclipse.birt.tests.performance");
                testElement.setAttribute("URL", GenCaseResult.getPerformanceFilePath(performancePath));
                DOMElement detailElement = new DOMElement("compileStatus");
                if (compileError) {
                    detailElement.setText("Fail");
                    detailElement.setAttribute("color", CONSTANT_RED);
                    detailElement.setAttribute("boldStyle", CONSTANT_BOLD);
                } else {
                    detailElement.setText("Pass");
                    detailElement.setAttribute("color", CONSTANT_BLACK);
                    detailElement.setAttribute("boldStyle", CONSTANT_NORMAL);
                }
                testElement.add((Element)detailElement);
                this.rootElement.add((Element)testElement);
            } else {
                DOMElement testElement = new DOMElement("smoketest");
                int index = reportType.indexOf("DTE");
                if (index == -1) {
                    index = reportType.indexOf("Engine");
                    if (index == -1) {
                        return;
                    }
                    testElement.setAttribute("id", "Engine Smoke");
                } else {
                    testElement.setAttribute("id", "DTE Smoke");
                }
                testElement.setAttribute("total", this.TotalRpt.trim());
                testElement.setAttribute("same", this.SameRpt.trim());
                DOMElement detailElement = new DOMElement("diff");
                detailElement.setText(this.DiffRpt);
                if (Integer.parseInt(this.DiffRpt.trim()) > 0) {
                    detailElement.setAttribute("color", CONSTANT_RED);
                    detailElement.setAttribute("boldStyle", CONSTANT_BOLD);
                } else {
                    detailElement.setAttribute("color", CONSTANT_BLACK);
                    detailElement.setAttribute("boldStyle", CONSTANT_NORMAL);
                }
                testElement.add((Element)detailElement);
                this.rootElement.add((Element)testElement);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

