/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ExportManifestUtils {
    static int package_count = 0;
    static final String[] API_JAR_PATTERNS = new String[]{"chartengineapi.jar", "com.ibm.icu.*.jar", "org.apache.commons.codec_.*.jar", "coreapi.jar", "dataaggregationapi.jar", "dataadapterapi.jar", "dteapi.jar", "engineapi.jar", "emitterconfig.jar", "flute.jar", "js.jar", "modelapi.jar", "crosstabcoreapi.jar", "dataextraction.jar", "chartitemapi.jar", "org.eclipse.emf.common_.*.jar", "org.eclipse.emf.ecore.xmi_.*.jar", "org.eclipse.emf.ecore_.*.jar", "org.w3c.css.sac_.*.jar", "scriptapi.jar", "modelodaapi.jar", "odadesignapi.jar", "javax.servlet_.*.jar", "chartexamplescoreapi.jar", "javax.servlet.jsp_.*.jar", "org.eclipse.birt.axis.overlay_.*.jar"};
    static final Boolean[] API_JAR_VERSIONS = new Boolean[]{false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

    public static void main(String[] args) throws IOException {
        String jarFolder = ".";
        if (args.length > 0) {
            jarFolder = args[0];
        }
        File[] jarFiles = new File(jarFolder).listFiles();
        int i = 0;
        while (i < jarFiles.length) {
            if (ExportManifestUtils.isApiJar(jarFiles[i])) {
                ExportManifestUtils.countPackages(jarFiles[i]);
            }
            ++i;
        }
        i = 0;
        while (i < jarFiles.length) {
            if (ExportManifestUtils.isApiJar(jarFiles[i])) {
                ExportManifestUtils.exportPackages(jarFiles[i]);
            }
            ++i;
        }
    }

    static boolean isApiJar(File jarFile) {
        String name = jarFile.getName();
        int i = 0;
        while (i < API_JAR_PATTERNS.length) {
            if (name.matches(API_JAR_PATTERNS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static Boolean getVersion(File jarFile) {
        String name = jarFile.getName();
        int i = 0;
        while (i < API_JAR_PATTERNS.length) {
            if (name.matches(API_JAR_PATTERNS[i])) {
                return API_JAR_VERSIONS[i];
            }
            ++i;
        }
        return null;
    }

    static void countPackages(File jarFile) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Entry root = new Entry();
        String fileName = jarFile.getName();
        root.hasVersion = ExportManifestUtils.getVersion(jarFile);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            ExportManifestUtils.createEntry(root, entry);
        }
        int i = 0;
        while (i < root.children.size()) {
            ExportManifestUtils.countEntry((Entry)root.children.get(i), "");
            ++i;
        }
    }

    static void exportPackages(File jarFile) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Entry root = new Entry();
        String fileName = jarFile.getName();
        root.hasVersion = ExportManifestUtils.getVersion(jarFile);
        if (root.hasVersion.booleanValue()) {
            int startIdx = fileName.indexOf("_");
            int endIdx = fileName.lastIndexOf(".");
            root.version = fileName.substring(startIdx + 1, endIdx - 1);
            endIdx = root.version.lastIndexOf(".");
            root.version = root.version.substring(0, endIdx);
        }
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            ExportManifestUtils.createEntry(root, entry);
        }
        int i = 0;
        while (i < root.children.size()) {
            ExportManifestUtils.outputEntry((Entry)root.children.get(i), "");
            ++i;
        }
    }

    static void countEntry(Entry entry, String prefix) {
        if (entry.hasFiles && !entry.name.equals("META-INF") && prefix != "") {
            ++package_count;
        }
        if (entry.children.size() > 0) {
            prefix = prefix != null && prefix.length() != 0 ? String.valueOf(prefix) + "." + entry.name : entry.name;
        }
        int i = 0;
        while (i < entry.children.size()) {
            ExportManifestUtils.countEntry((Entry)entry.children.get(i), prefix);
            ++i;
        }
    }

    static void outputEntry(Entry entry, String prefix) {
        if (entry.hasFiles && !entry.name.equals("META-INF") && prefix != "") {
            String output = " ";
            output = entry.hasVersion != false ? String.valueOf(output) + prefix + "." + entry.name + ";version=\"" + entry.version + "\"" : String.valueOf(output) + prefix + "." + entry.name;
            if (--package_count == 0) {
                System.out.println(output);
            } else if (!output.trim().startsWith("META-INF")) {
                System.out.println(String.valueOf(output) + ",");
            }
        }
        if (entry.children.size() > 0) {
            prefix = prefix != null && prefix.length() != 0 ? String.valueOf(prefix) + "." + entry.name : entry.name;
        }
        int i = 0;
        while (i < entry.children.size()) {
            ExportManifestUtils.outputEntry((Entry)entry.children.get(i), prefix);
            ++i;
        }
    }

    static void createEntry(Entry root, JarEntry entry) {
        if (entry.isDirectory()) {
            String name = entry.getName();
            String[] names = name.split("/");
            if (names[0].equals("MATA-INF")) {
                return;
            }
            int i = 0;
            while (i < names.length) {
                root = ExportManifestUtils.createEntry(root, names[i]);
                ++i;
            }
        } else {
            String name = entry.getName();
            String[] names = name.split("/");
            int i = 0;
            while (i < names.length - 1) {
                root = ExportManifestUtils.createEntry(root, names[i]);
                ++i;
            }
            root.hasFiles = true;
        }
    }

    static Entry createEntry(Entry parent, String name) {
        int i = 0;
        while (i < parent.children.size()) {
            Entry entry = (Entry)parent.children.get(i);
            if (name.equals(entry.name)) {
                return entry;
            }
            ++i;
        }
        Entry entry = new Entry();
        entry.name = name;
        entry.version = parent.version;
        entry.hasVersion = parent.hasVersion;
        parent.children.add(entry);
        return entry;
    }

    static class Entry {
        String name;
        Boolean hasVersion;
        String version;
        boolean hasFiles;
        ArrayList children = new ArrayList();

        Entry() {
        }
    }
}

