/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.strategy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.extension.IStyleDeclaration;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.MultiViews;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.strategy.ReportItemPropSearchStrategy;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedItemPropSearchStrategy
extends ReportItemPropSearchStrategy {
    protected static final Set<Integer> hostViewRelatedProps;
    private static final ExtendedItemPropSearchStrategy instance;

    static {
        HashSet<Integer> tmpSet = new HashSet<Integer>();
        tmpSet.add(new Integer("display".hashCode()));
        tmpSet.add(new Integer("masterPage".hashCode()));
        tmpSet.add(new Integer("pageBreakBefore".hashCode()));
        tmpSet.add(new Integer("pageBreakAfter".hashCode()));
        tmpSet.add(new Integer("pageBreakInside".hashCode()));
        tmpSet.add(new Integer("showIfBlank".hashCode()));
        tmpSet.add(new Integer("toc".hashCode()));
        tmpSet.add(new Integer("bookmark".hashCode()));
        tmpSet.add(new Integer("visibility".hashCode()));
        tmpSet.add(new Integer("allowExport".hashCode()));
        tmpSet.add(new Integer("zIndex".hashCode()));
        hostViewRelatedProps = Collections.unmodifiableSet(tmpSet);
        instance = new ExtendedItemPropSearchStrategy();
    }

    protected ExtendedItemPropSearchStrategy() {
    }

    public static PropertySearchStrategy getInstance() {
        return instance;
    }

    @Override
    protected Object getPropertyFromSelfSelector(Module module, DesignElement element, ElementPropertyDefn prop) {
        String selector;
        ExtendedItem extendedItem = (ExtendedItem)element;
        Object value = null;
        ExtensionElementDefn elementDefn = extendedItem.getExtDefn();
        if (elementDefn != null && (value = this.getPropertyFromSelector(module, prop, selector = extendedItem.getExtDefn().getSelector())) != null) {
            return value;
        }
        value = this.getPropertyFromPredefinedStyles(module, extendedItem, prop);
        if (value != null) {
            return value;
        }
        ElementDefn defn = (ElementDefn)MetaDataDictionary.getInstance().getElement(element.getElementName());
        String selector2 = defn.getSelector();
        return this.getPropertyFromSelector(module, prop, selector2);
    }

    private Object getPropertyFromPredefinedStyles(Module module, ExtendedItem extendedItem, ElementPropertyDefn prop) {
        List predefinedStyles = extendedItem.getReportItemDefinedSelectors(module);
        if (predefinedStyles == null || predefinedStyles.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < predefinedStyles.size()) {
            Object value;
            Object predefinedStyle = predefinedStyles.get(i);
            if (predefinedStyle instanceof String) {
                String styleName = (String)predefinedStyle;
                value = this.getPropertyFromSelector(module, prop, styleName);
                if (value != null) {
                    return value;
                }
            } else if (predefinedStyle instanceof IStyleDeclaration) {
                IStyleDeclaration style = (IStyleDeclaration)predefinedStyle;
                value = style.getProperty(prop.getName());
                if (value != null) {
                    try {
                        value = prop.validateValue(module, value);
                        if (value != null) {
                            return value;
                        }
                    }
                    catch (PropertyValueException propertyValueException) {}
                }
            } else assert (false);
            ++i;
        }
        return null;
    }

    @Override
    protected Object getPropertyFromSelf(Module module, DesignElement element, ElementPropertyDefn prop) {
        if (!(element.getContainer() instanceof MultiViews)) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        String propName = prop.getName();
        if (!ExtendedItemPropSearchStrategy.isDataBindingProperty(element, propName) && !ExtendedItemPropSearchStrategy.isHostViewProperty(element, propName)) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        DesignElement grandContainer = element.getContainer().getContainer();
        if (grandContainer == null) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        return grandContainer.getProperty(module, prop);
    }

    private static Set<Integer> getHostViewProperties(DesignElement tmpElement) {
        if (tmpElement instanceof ReportItem) {
            return hostViewRelatedProps;
        }
        return Collections.EMPTY_SET;
    }

    public static boolean isHostViewProperty(DesignElement element, String propName) {
        if (!(element instanceof ExtendedItem) || StringUtil.isBlank(propName)) {
            return false;
        }
        return ExtendedItemPropSearchStrategy.getHostViewProperties(element).contains(new Integer(propName.hashCode()));
    }

    @Override
    protected Object getNonIntrinsicPropertyFromElement(Module module, DesignElement element, ElementPropertyDefn prop) {
        ExtendedItem extendedItem = (ExtendedItem)element;
        ElementPropertyDefn propDefn = extendedItem.getPropertyDefn(prop.getName());
        if (propDefn == null) {
            return null;
        }
        if (!propDefn.enableContextSearch()) {
            return super.getNonIntrinsicPropertyFromElement(module, element, prop);
        }
        IReportItem reportItem = extendedItem.getExtendedElement();
        if (reportItem != null) {
            return reportItem.getProperty(prop.getName());
        }
        return null;
    }

    public Object getMetaFactoryProperty(Module module, DesignElement element, ElementPropertyDefn prop) {
        assert (prop.isSystemProperty() && ((SystemPropertyDefn)prop).enableContextSearch());
        return super.getNonIntrinsicPropertyFromElement(module, element, prop);
    }

    @Override
    protected DesignElement getStyleContainer(DesignElement designElement) {
        DesignElement tmpContainer = designElement.getContainer();
        if (tmpContainer == null || !(tmpContainer instanceof MultiViews)) {
            return tmpContainer;
        }
        assert (tmpContainer instanceof MultiViews);
        if ((tmpContainer = tmpContainer.getContainer()) == null) {
            return null;
        }
        return tmpContainer.getContainer();
    }
}

