/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.net.URL;
import java.util.List;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.CssException;
import org.eclipse.birt.report.model.api.command.CssReloadedEvent;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.CssRecord;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetAdapter;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ModelUtil;

public class CssCommand
extends AbstractElementCommand {
    private static final int APPEND_POS = -1;

    public CssCommand(Module module, DesignElement element) {
        super(module, element);
    }

    public void addCss(String fileName) throws SemanticException {
        IncludedCssStyleSheet cssStruct = StructureFactory.createIncludedCssStyleSheet();
        cssStruct.setFileName(fileName);
        this.addCss(cssStruct);
    }

    public void addCss(IncludedCssStyleSheet cssStruct) throws SemanticException {
        String fileName = cssStruct.getFileName();
        CssStyleSheet sheet = null;
        try {
            sheet = this.module.loadCss(fileName);
        }
        catch (StyleSheetException e) {
            throw ModelUtil.convertSheetExceptionToCssException(this.module, cssStruct, fileName, e);
        }
        this.doAddCssSheet(cssStruct, sheet, -1);
    }

    public void addCss(CssStyleSheet sheet) throws SemanticException {
        if (sheet == null) {
            return;
        }
        String fileName = sheet.getFileName();
        if (this.getCssStyleSheetByLocation(fileName) != null) {
            throw new CssException(this.module, new String[]{fileName}, "Error.CSSException.DUPLICATE_CSS");
        }
        IncludedCssStyleSheet css = StructureFactory.createIncludedCssStyleSheet();
        css.setFileName(sheet.getFileName());
        this.doAddCssSheet(css, sheet, -1);
    }

    private void doAddCssStruct(IncludedCssStyleSheet css, int posn) throws SemanticException {
        assert (css != null);
        ElementPropertyDefn propDefn = this.element.getPropertyDefn("cssStyleSheets");
        ComplexPropertyCommand propCommand = new ComplexPropertyCommand(this.module, this.element);
        if (posn == -1) {
            propCommand.addItem((MemberRef)new CachedMemberRef(propDefn), (Object)css);
        } else {
            propCommand.insertItem(new CachedMemberRef(propDefn), css, posn);
        }
    }

    private void doAddCssSheet(IncludedCssStyleSheet cssStruct, CssStyleSheet sheet, int posn) throws SemanticException {
        if (cssStruct == null || sheet == null) {
            return;
        }
        ActivityStack activityStack = this.getActivityStack();
        CssRecord record = null;
        record = posn == -1 ? new CssRecord(this.module, this.element, sheet, true) : new CssRecord(this.module, this.element, sheet, true, posn);
        activityStack.startTrans(record.getLabel());
        this.getActivityStack().execute(record);
        try {
            this.doAddCssStruct(cssStruct, posn);
        }
        catch (SemanticException e) {
            activityStack.rollback();
            throw e;
        }
        activityStack.commit();
    }

    public void dropCss(CssStyleSheet sheet) throws SemanticException {
        if (sheet == null) {
            return;
        }
        String fileName = sheet.getFileName();
        if (fileName == null) {
            return;
        }
        IncludedCssStyleSheet css = this.getIncludedCssStyleSheetByLocation(fileName);
        ICssStyleSheetOperation cssOperation = (ICssStyleSheetOperation)((Object)this.element);
        int position = cssOperation.getCsses().indexOf(sheet);
        if (css == null || position == -1) {
            throw new CssException(this.module, css, new String[]{fileName}, "Error.CSSException.CSS_NOT_FOUND");
        }
        ActivityStack stack = this.getActivityStack();
        CssRecord record = new CssRecord(this.module, this.element, sheet, false, position);
        stack.startTrans(record.getLabel());
        this.getActivityStack().execute(record);
        this.removeIncludeCss(css);
        this.getActivityStack().commit();
    }

    private void removeIncludeCss(IncludedCssStyleSheet css) throws SemanticException {
        ElementPropertyDefn propDefn = this.element.getPropertyDefn("cssStyleSheets");
        ComplexPropertyCommand propCommand = new ComplexPropertyCommand(this.module, this.element);
        propCommand.removeItem((MemberRef)new CachedMemberRef(propDefn), css);
    }

    private CssStyleSheet getCssStyleSheetByLocation(String location) {
        ICssStyleSheetOperation sheet = (ICssStyleSheetOperation)((Object)this.element);
        List csses = sheet.getCsses();
        URL url = this.module.findResource(location, 3);
        if (url == null) {
            return null;
        }
        return CssStyleSheetAdapter.getCssStyleSheetByLocation(this.module, csses, url);
    }

    public IncludedCssStyleSheet getIncludedCssStyleSheetByLocation(String location) {
        if (location == null) {
            return null;
        }
        ICssStyleSheetOperation sheet = (ICssStyleSheetOperation)((Object)this.element);
        List csses = sheet.getCsses();
        int position = CssStyleSheetAdapter.getPositionOfCssStyleSheet(this.module, csses, location);
        if (position == -1) {
            return null;
        }
        csses = this.element.getListProperty(this.module, "cssStyleSheets");
        return (IncludedCssStyleSheet)csses.get(position);
    }

    public void reloadCss(CssStyleSheet sheet) throws SemanticException {
        if (sheet == null) {
            return;
        }
        IncludedCssStyleSheet cssSheet = this.getIncludedCssStyleSheetByLocation(sheet.getFileName());
        String fileName = cssSheet.getFileName();
        String externalCssURI = cssSheet.getExternalCssURI();
        ActivityStack stack = this.module.getActivityStack();
        stack.startSilentTrans(true);
        CssStyleSheet newStyleSheet = null;
        try {
            int posn = this.findIncludedCssStyleSheetPosition(sheet);
            this.dropCss(sheet);
            try {
                newStyleSheet = this.module.loadCss(fileName);
            }
            catch (StyleSheetException styleSheetException) {
                newStyleSheet = null;
            }
            IncludedCssStyleSheet css = StructureFactory.createIncludedCssStyleSheet();
            css.setFileName(sheet.getFileName());
            css.setExternalCssURI(externalCssURI);
            if (newStyleSheet == null) {
                this.doAddCssStruct(css, posn);
            }
            this.doAddCssSheet(css, newStyleSheet, posn);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        this.doPostReloadAction(newStyleSheet);
    }

    private int findIncludedCssStyleSheetPosition(CssStyleSheet sheet) {
        List includedCss = this.element.getListProperty(this.module, "cssStyleSheets");
        int i = 0;
        while (i < includedCss.size()) {
            IncludedCssStyleSheet oneCss = (IncludedCssStyleSheet)includedCss.get(i);
            assert (oneCss.getFileName() != null);
            if (oneCss.getFileName().equalsIgnoreCase(sheet.getFileName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private IncludedCssStyleSheet findIncludedCssStyleSheet(CssStyleSheet sheet) {
        List includedCss = this.element.getListProperty(this.module, "cssStyleSheets");
        int posn = this.findIncludedCssStyleSheetPosition(sheet);
        if (posn == -1) {
            return null;
        }
        return (IncludedCssStyleSheet)includedCss.get(posn);
    }

    private int findIncludedCssStyleSheetPosition(String fileName) {
        List includedCss = this.element.getListProperty(this.module, "cssStyleSheets");
        int i = 0;
        while (i < includedCss.size()) {
            IncludedCssStyleSheet oneCss = (IncludedCssStyleSheet)includedCss.get(i);
            assert (oneCss.getFileName() != null);
            if (oneCss.getFileName().equalsIgnoreCase(fileName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void doPostReloadAction(CssStyleSheet css) {
        CssReloadedEvent event = new CssReloadedEvent(this.module, css);
        this.module.broadcast(event);
        ActivityStack activityStack = this.module.getActivityStack();
        activityStack.commit();
        activityStack.flush();
        this.module.setSaveState(0);
        activityStack.sendNotifcations(new ActivityStackEvent(activityStack, 1));
        this.module.getModuleHandle().checkReport();
    }

    public IncludedCssStyleSheet checkRenameCss(IncludedCssStyleSheet includedCssSheet, String newFileName) throws CssException {
        if (!this.element.canEdit(this.module)) {
            throw new CssException(this.module, new String[]{newFileName}, "Error.CssException.READONLY");
        }
        URL url = this.module.findResource(newFileName, 3);
        if (url == null) {
            throw new CssException(this.module, new String[]{newFileName}, "Error.CSSException.CSS_NOT_FOUND");
        }
        CssStyleSheet sheet = CssStyleSheetAdapter.getCssStyleSheetByLocation(this.module, ((ICssStyleSheetOperation)((Object)this.element)).getCsses(), url);
        if (sheet != null) {
            IncludedCssStyleSheet tmpIncludedCssStyleSheet = this.findIncludedCssStyleSheet(sheet);
            if (includedCssSheet != tmpIncludedCssStyleSheet) {
                throw new CssException(this.module, new String[]{newFileName}, "Error.CSSException.DUPLICATE_CSS");
            }
            return tmpIncludedCssStyleSheet;
        }
        return null;
    }

    public void renameCss(IncludedCssStyleSheet includedCssStyleSheet, String newFileName) throws SemanticException {
        if (includedCssStyleSheet == null || newFileName == null) {
            return;
        }
        if (includedCssStyleSheet.getFileName().equals(newFileName)) {
            return;
        }
        IncludedCssStyleSheet foundIncludedCssStyleSheet = this.checkRenameCss(includedCssStyleSheet, newFileName);
        if (foundIncludedCssStyleSheet == includedCssStyleSheet) {
            return;
        }
        String externalCssURI = includedCssStyleSheet.getExternalCssURI();
        String fileName = includedCssStyleSheet.getFileName();
        CssStyleSheet sheet = this.getCssStyleSheetByLocation(fileName);
        IncludedCssStyleSheet css = StructureFactory.createIncludedCssStyleSheet();
        css.setFileName(newFileName);
        css.setExternalCssURI(externalCssURI);
        int posn = this.findIncludedCssStyleSheetPosition(fileName);
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.RenameCSSFile"));
        CssStyleSheet newStyleSheet = null;
        try {
            if (sheet == null) {
                this.removeIncludeCss(includedCssStyleSheet);
            } else {
                this.dropCss(sheet);
            }
            try {
                newStyleSheet = this.module.loadCss(newFileName);
            }
            catch (StyleSheetException styleSheetException) {
                newStyleSheet = null;
            }
            if (newStyleSheet == null) {
                this.doAddCssStruct(css, posn);
            }
            this.doAddCssSheet(css, newStyleSheet, posn);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }
}

