/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.olap;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.interfaces.ICubeModel;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.Measure;

public abstract class CubeHandle
extends ReportElementHandle
implements ICubeModel {
    public CubeHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public DimensionHandle getDimension(String dimensionName) {
        DesignElement dimension = this.module.findOLAPElement(dimensionName);
        if (dimension instanceof Dimension && dimension.isContentOf(this.getElement())) {
            return (DimensionHandle)dimension.getHandle(this.module);
        }
        return null;
    }

    public MeasureHandle getMeasure(String measureName) {
        DesignElement measure = this.module.findOLAPElement(measureName);
        if (measure instanceof Measure && measure.isContentOf(this.getElement())) {
            return (MeasureHandle)measure.getHandle(this.module);
        }
        return null;
    }

    public Iterator filtersIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("filter");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    public MeasureGroupHandle getDefaultMeasureGroup() {
        DesignElement measureGroup = ((Cube)this.getElement()).getDefaultMeasureGroup(this.module);
        return measureGroup == null ? null : (MeasureGroupHandle)measureGroup.getHandle(this.module);
    }

    public void setDefaultMeasureGroup(MeasureGroupHandle defaultMeasureGroup) throws SemanticException {
        this.setProperty("defaultMeasureGroup", defaultMeasureGroup);
    }

    public Iterator accessControlsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("accessControls");
        return propHandle.getContents().iterator();
    }

    public void addFilter(FilterCondition fc) throws SemanticException {
        PropertyHandle propHandle = this.getPropertyHandle("filter");
        propHandle.addItem(fc);
    }

    public void removeFilter(FilterCondition fc) throws SemanticException {
        PropertyHandle propHandle = this.getPropertyHandle("filter");
        propHandle.removeItem(fc);
    }
}

