/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.parser.CascadingParameterGroupState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ParameterGroupState;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.ScalarParameterState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.AnyElementState;
import org.eclipse.birt.report.model.util.XMLParserHandler;

public class ParametersState
extends AbstractParseState {
    private ModuleParserHandler handler;
    private DesignElement container;
    private int slotID;
    private boolean isReport = true;

    public ParametersState(ModuleParserHandler handler) {
        this.handler = handler;
        this.container = handler.getModule();
        this.slotID = 1;
    }

    public ParametersState(ModuleParserHandler handler, DesignElement container, int slotID) {
        this.handler = handler;
        this.container = container;
        this.slotID = slotID;
        this.isReport = container instanceof ReportDesign;
    }

    public AbstractParseState startElement(String tagName) {
        int tagValue = tagName.toLowerCase().hashCode();
        if (this.isReport) {
            if (ParserSchemaConstants.PARAMETER_GROUP_TAG == tagValue) {
                return new ParameterGroupState(this.handler);
            }
            if (ParserSchemaConstants.CASCADING_PARAMETER_GROUP_TAG == tagValue) {
                return new CascadingParameterGroupState(this.handler);
            }
        }
        if (ParserSchemaConstants.SCALAR_PARAMETER_TAG == tagValue) {
            return new ScalarParameterState(this.handler, this.container, this.slotID);
        }
        if (ParserSchemaConstants.FILTER_PARAMETER_TAG == tagValue) {
            return new AnyElementState(this.handler);
        }
        if (ParserSchemaConstants.LIST_PARAMETER_TAG == tagValue) {
            return new AnyElementState(this.handler);
        }
        if (ParserSchemaConstants.TABLE_PARAMETER_TAG == tagValue) {
            return new AnyElementState(this.handler);
        }
        return super.startElement(tagName);
    }

    public XMLParserHandler getHandler() {
        return this.handler;
    }
}

