/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.validators.CascadingParameterTypeValidator;
import org.eclipse.birt.report.model.api.validators.DataSetNameRequiredValidator;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.Parameter;
import org.eclipse.birt.report.model.elements.interfaces.IScalarParameterModel;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class ScalarParameter
extends Parameter
implements IScalarParameterModel {
    public ScalarParameter() {
    }

    public ScalarParameter(String theName) {
        super(theName);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitScalarParameter(this);
    }

    public String getElementName() {
        return "ScalarParameter";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public ScalarParameterHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new ScalarParameterHandle(module, this);
        }
        return (ScalarParameterHandle)this.handle;
    }

    public List validate(Module module) {
        List list = super.validate(module);
        list.addAll(DataSetNameRequiredValidator.getInstance().validate(module, this));
        list.addAll(CascadingParameterTypeValidator.getInstance().validate(module, this));
        return list;
    }

    public DataSet getDataSetElement(Module module) {
        ElementRefValue dataSetRef = (ElementRefValue)this.getProperty(module, "dataSetName");
        if (dataSetRef == null) {
            return null;
        }
        return (DataSet)dataSetRef.getElement();
    }
}

