/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IPropertyDefinition;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.validators.ExtensionValidator;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.interfaces.IExtendedItemModel;
import org.eclipse.birt.report.model.elements.strategy.ExtendedItemPropSearchStrategy;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.extension.PeerExtensibilityProvider;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.parser.treebuild.ContentTree;
import org.eclipse.birt.report.model.parser.treebuild.IContentHandler;

public class ExtendedItem
extends ReportItem
implements IExtendableElement,
IExtendedItemModel,
IContentHandler {
    protected String extensionName = null;
    protected PeerExtensibilityProvider provider = null;
    private ContentTree contentTree = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.elements.ExtendedItem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ExtendedItem() {
    }

    public ExtendedItem(String theName) {
        super(theName);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitExtendedItem(this);
    }

    public String getElementName() {
        return "ExtendedItem";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public ExtendedItemHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new ExtendedItemHandle(module, this);
        }
        return (ExtendedItemHandle)this.handle;
    }

    public boolean hasLocalPropertyValues() {
        if (super.hasLocalPropertyValues()) {
            return true;
        }
        if (this.provider != null) {
            return this.provider.hasLocalPropertyValues();
        }
        return false;
    }

    public Object getLocalProperty(Module module, ElementPropertyDefn prop) {
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        if (!prop.isExtended()) {
            return super.getLocalProperty(module, prop);
        }
        if (this.provider != null) {
            return this.provider.getExtensionProperty(prop.getName());
        }
        return null;
    }

    public void setProperty(ElementPropertyDefn prop, Object value) {
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        if (!prop.isExtended()) {
            super.setProperty(prop, value);
        } else if (this.provider != null) {
            this.provider.setExtensionProperty(prop, value);
        }
    }

    public ElementPropertyDefn getPropertyDefn(String propName) {
        if (!$assertionsDisabled && propName == null) {
            throw new AssertionError();
        }
        ElementPropertyDefn propDefn = super.getPropertyDefn(propName);
        if (propDefn != null) {
            return propDefn;
        }
        if (this.provider != null) {
            return (ElementPropertyDefn)this.provider.getPropertyDefn(propName);
        }
        return propDefn;
    }

    public List getPropertyDefns() {
        if (this.provider != null) {
            return this.provider.getPropertyDefns();
        }
        return super.getPropertyDefns();
    }

    public ExtensionElementDefn getExtDefn() {
        if (this.provider != null) {
            return this.provider.getExtDefn();
        }
        return null;
    }

    public void initializeReportItem(Module module) throws ExtendedElementException {
        if (this.provider == null) {
            throw new ExtendedElementException((DesignElement)this, "org.eclipse.birt.report.model", "Error.SemanticError.MISSING_EXTENSION", null);
        }
        this.provider.initializeReportItem(module);
    }

    public PeerExtensibilityProvider getExtensibilityProvider() {
        return this.provider;
    }

    protected Object getIntrinsicProperty(String propName) {
        if ("extensionName".equals(propName)) {
            return this.extensionName;
        }
        return super.getIntrinsicProperty(propName);
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if ("extensionName".equals(propName)) {
            this.setExtensionName((String)value);
        } else {
            super.setIntrinsicProperty(propName, value);
        }
    }

    public List validate(Module module) {
        List list = super.validate(module);
        list.addAll(ExtensionValidator.getInstance().validate(module, this));
        return list;
    }

    public IReportItem getExtendedElement() {
        if (this.provider != null) {
            return this.provider.getExtensionElement();
        }
        return null;
    }

    protected Object baseClone() throws CloneNotSupportedException {
        ExtendedItem clonedElement = (ExtendedItem)super.baseClone();
        clonedElement.provider = new PeerExtensibilityProvider(clonedElement, clonedElement.extensionName);
        clonedElement.provider.copyFrom(this.provider);
        return clonedElement;
    }

    public boolean isExtensionModelProperty(String propName) {
        if (this.provider != null) {
            return this.provider.isExtensionModelProperty(propName);
        }
        return false;
    }

    public boolean isExtensionXMLProperty(String propName) {
        if (this.provider != null) {
            return this.provider.isExtensionXMLProperty(propName);
        }
        return false;
    }

    public List getMethods() {
        if (this.provider != null) {
            return this.provider.getModelMethodDefns();
        }
        return this.getDefn().getMethods();
    }

    public String getScriptPropertyName() {
        if (this.provider != null) {
            IPropertyDefinition defn = this.provider.getScriptPropertyDefinition();
            return defn == null ? null : defn.getName();
        }
        return null;
    }

    public PropertySearchStrategy getStrategy() {
        return ExtendedItemPropSearchStrategy.getInstance();
    }

    private void setExtensionName(String extension) {
        this.extensionName = extension;
        if (this.extensionName != null) {
            this.provider = new PeerExtensibilityProvider(this, this.extensionName);
            this.initSlots();
        } else {
            this.provider = null;
        }
    }

    public ContainerSlot getSlot(int slot) {
        if (!($assertionsDisabled || slot >= 0 && slot < this.getDefn().getSlotCount())) {
            throw new AssertionError();
        }
        return this.slots[slot];
    }

    public IElementDefn getDefn() {
        ExtensionElementDefn extDefn = this.getExtDefn();
        if (extDefn != null) {
            return extDefn;
        }
        return super.getDefn();
    }

    public IElementDefn getDefaultDefn() {
        return super.getDefn();
    }

    public ContentTree getContentTree() {
        return this.contentTree;
    }

    public void initializeContentTree() {
        if (this.contentTree == null) {
            this.contentTree = new ContentTree();
        }
    }

    public boolean hasLocalPropertyValuesOnOwnModel() {
        if (this.provider == null) {
            return false;
        }
        return this.provider.hasLocalPropertyValuesOnOwnModel();
    }

    public List getReportItemDefinedSelectors(Module module) {
        IReportItem reportItem = this.getExtendedElement();
        try {
            if (reportItem == null) {
                this.initializeReportItem(module);
                reportItem = this.getExtendedElement();
            }
        }
        catch (ExtendedElementException extendedElementException) {}
        if (reportItem == null) {
            return Collections.EMPTY_LIST;
        }
        return reportItem.getPredefinedStyles();
    }

    public String getLocalEncryptionID(ElementPropertyDefn propDefn) {
        if (propDefn == null || !propDefn.isEncryptable()) {
            return null;
        }
        if (!propDefn.isExtended()) {
            return super.getLocalEncryptionID(propDefn);
        }
        if (this.provider != null) {
            return this.provider.getEncryptionHelperID(propDefn);
        }
        return null;
    }

    public void setEncryptionHelper(ElementPropertyDefn propDefn, String encryptionID) {
        if (!propDefn.isExtended()) {
            super.setEncryptionHelper(propDefn, encryptionID);
        }
        if (this.provider != null) {
            this.provider.setEncryptionHelper(propDefn, encryptionID);
        }
    }

    protected boolean hasLocalValue(ElementPropertyDefn propDefn) {
        if (propDefn == null) {
            return false;
        }
        if (!propDefn.isExtended()) {
            return super.hasLocalValue(propDefn);
        }
        if (this.provider != null) {
            return this.provider.getExtensionProperty(propDefn.getName()) != null;
        }
        return false;
    }
}

