/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.validators.AbstractPropertyValidator;

public class StructureReferenceValidator
extends AbstractPropertyValidator {
    public static final String NAME = "StructureReferenceValidator";
    private static final StructureReferenceValidator instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.validators.StructureReferenceValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        instance = new StructureReferenceValidator();
    }

    public static StructureReferenceValidator getInstance() {
        return instance;
    }

    public List validate(Module module, DesignElement element, String propName) {
        ArrayList<SemanticError> list = new ArrayList<SemanticError>();
        if (!this.checkStructureReference(module, element, propName)) {
            Object value = element.getLocalProperty(module, propName);
            list.add(new SemanticError(element, new String[]{propName, ((StructRefValue)value).getName()}, "Error.SemanticError.INVALID_STRUCTURE_REF"));
        }
        return list;
    }

    private boolean checkStructureReference(Module module, DesignElement element, String propName) {
        if (!$assertionsDisabled && StringUtil.isBlank(propName)) {
            throw new AssertionError();
        }
        Object value = element.getLocalProperty(module, propName);
        if (value == null) {
            return true;
        }
        ElementPropertyDefn prop = element.getPropertyDefn(propName);
        if (!$assertionsDisabled && 19 != prop.getTypeCode()) {
            throw new AssertionError();
        }
        StructRefValue ref = (StructRefValue)value;
        ref = element.resolveStructReference(module, prop);
        return ref.isResolved();
    }
}

