/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.dsn;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeUtility;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.eclipse.angus.mail.dsn.MessageHeaders;

public class text_rfc822headers
implements DataContentHandler {
    private static final ActivationDataFlavor myDF = new ActivationDataFlavor(MessageHeaders.class, "text/rfc822-headers", "RFC822 headers");
    private static final ActivationDataFlavor myDFs = new ActivationDataFlavor(String.class, "text/rfc822-headers", "RFC822 headers");

    public ActivationDataFlavor[] getTransferDataFlavors() {
        return new ActivationDataFlavor[]{myDF, myDFs};
    }

    public Object getTransferData(ActivationDataFlavor df, DataSource ds) throws IOException {
        if (myDF.equals(df)) {
            return this.getContent(ds);
        }
        if (myDFs.equals(df)) {
            return this.getStringContent(ds);
        }
        return null;
    }

    public Object getContent(DataSource ds) throws IOException {
        try {
            return new MessageHeaders(ds.getInputStream());
        }
        catch (MessagingException mex) {
            throw new IOException("Exception creating MessageHeaders: " + mex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getStringContent(DataSource ds) throws IOException {
        String enc = null;
        InputStreamReader is = null;
        try {
            enc = this.getCharset(ds.getContentType());
            is = new InputStreamReader(ds.getInputStream(), enc);
        }
        catch (IllegalArgumentException iex) {
            throw new UnsupportedEncodingException(enc);
        }
        try {
            int count;
            int pos = 0;
            char[] buf = new char[1024];
            while ((count = is.read(buf, pos, buf.length - pos)) != -1) {
                if ((pos += count) < buf.length) continue;
                int size = buf.length;
                size += Math.min(size, 262144);
                char[] tbuf = new char[size];
                System.arraycopy(buf, 0, tbuf, 0, pos);
                buf = tbuf;
            }
            String string = new String(buf, 0, pos);
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void writeTo(Object obj, String type, OutputStream os) throws IOException {
        if (obj instanceof MessageHeaders) {
            MessageHeaders mh = (MessageHeaders)((Object)obj);
            try {
                mh.writeTo(os);
            }
            catch (MessagingException mex) {
                Exception ex = mex.getNextException();
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw new IOException("Exception writing headers: " + mex);
            }
            return;
        }
        if (!(obj instanceof String)) {
            throw new IOException("\"" + myDFs.getMimeType() + "\" DataContentHandler requires String object, was given object of type " + obj.getClass().toString());
        }
        String enc = null;
        OutputStreamWriter osw = null;
        try {
            enc = this.getCharset(type);
            osw = new OutputStreamWriter(os, enc);
        }
        catch (IllegalArgumentException iex) {
            throw new UnsupportedEncodingException(enc);
        }
        String s = (String)obj;
        osw.write(s, 0, s.length());
        osw.flush();
    }

    private String getCharset(String type) {
        try {
            ContentType ct = new ContentType(type);
            String charset = ct.getParameter("charset");
            if (charset == null) {
                charset = "us-ascii";
            }
            return MimeUtility.javaCharset((String)charset);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

