/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util.connector.suite;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.internal.test.util.TestFileUtils;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.Transfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorTestUtils {
    public static <T extends Transfer> List<T> createTransfers(Class<T> cls, int count, File file) {
        ArrayList<T> ret = new ArrayList<T>();
        for (int i = 0; i < count; ++i) {
            DefaultArtifact artifact;
            String context = null;
            String checksumPolicy = "ignore";
            ArtifactUpload obj = null;
            if (cls.isAssignableFrom(ArtifactUpload.class)) {
                artifact = new DefaultArtifact("testGroup", "testArtifact", "sources", "jar", i + 1 + "-test");
                obj = new ArtifactUpload((Artifact)artifact, file);
            } else {
                DefaultMetadata metadata;
                if (cls.isAssignableFrom(ArtifactDownload.class)) {
                    try {
                        artifact = new DefaultArtifact("testGroup", "testArtifact", "sources", "jar", i + 1 + "-test");
                        obj = new ArtifactDownload((Artifact)artifact, context, ConnectorTestUtils.safeFile(file), checksumPolicy);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
                if (cls.isAssignableFrom(MetadataUpload.class)) {
                    metadata = new DefaultMetadata("testGroup", "testArtifact", i + 1 + "-test", "jar", Metadata.Nature.RELEASE_OR_SNAPSHOT, file);
                    obj = new MetadataUpload((Metadata)metadata, file);
                } else if (cls.isAssignableFrom(MetadataDownload.class)) {
                    try {
                        metadata = new DefaultMetadata("testGroup", "testArtifact", i + 1 + "-test", "jar", Metadata.Nature.RELEASE_OR_SNAPSHOT, file);
                        obj = new MetadataDownload((Metadata)metadata, context, ConnectorTestUtils.safeFile(file), checksumPolicy);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
            }
            ret.add(cls.cast(obj));
        }
        return ret;
    }

    private static File safeFile(File file) throws IOException {
        return file == null ? TestFileUtils.createTempFile("") : file;
    }
}

