/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util.connector.suite;

import java.util.Map;
import org.eclipse.aether.internal.test.impl.TestRepositorySystemSession;
import org.eclipse.aether.internal.test.util.connector.suite.ConnectorTestSetup;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.junit.After;
import org.junit.Before;

public abstract class ConnectorTestSuiteSetup {
    private ConnectorTestSetup connectorSetup = null;
    protected RemoteRepository repository;
    protected TestRepositorySystemSession session;
    private Map<String, Object> context = null;
    private RepositoryConnectorFactory factory;

    public ConnectorTestSuiteSetup(ConnectorTestSetup setup) {
        this.connectorSetup = setup;
        this.factory = setup.factory();
        try {
            this.context = this.connectorSetup.beforeClass(this.session);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while running ConnectorTestSetup#beforeClass.", e);
        }
    }

    @Before
    public void before() throws Exception {
        this.session = new TestRepositorySystemSession();
        this.repository = this.connectorSetup.before(this.session, this.context);
    }

    @After
    public void after() throws Exception {
        this.connectorSetup.after(this.session, this.repository, this.context);
    }

    protected RepositoryConnectorFactory factory() {
        return this.factory;
    }
}

