/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util.connector.suite;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.internal.test.util.TestFileUtils;
import org.eclipse.aether.internal.test.util.connector.suite.ConnectorTestSetup;
import org.eclipse.aether.internal.test.util.connector.suite.ConnectorTestSuiteSetup;
import org.eclipse.aether.internal.test.util.connector.suite.ConnectorTestUtils;
import org.eclipse.aether.internal.test.util.connector.suite.TransferEventTester;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.Transfer;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.junit.Assert;
import org.junit.Test;

public abstract class ConnectorTestSuite
extends ConnectorTestSuiteSetup {
    public ConnectorTestSuite(ConnectorTestSetup setup) {
        super(setup);
    }

    @Test
    public void testSuccessfulEvents() throws NoRepositoryConnectorException, IOException {
        TransferEventTester.testSuccessfulTransferEvents(this.factory(), this.session, this.repository);
    }

    @Test
    public void testFailedEvents() throws NoRepositoryConnectorException, IOException {
        TransferEventTester.testFailedTransferEvents(this.factory(), this.session, this.repository);
    }

    @Test
    public void testFileHandleLeakage() throws IOException, NoRepositoryConnectorException {
        DefaultArtifact artifact = new DefaultArtifact("testGroup", "testArtifact", "", "jar", "1-test");
        DefaultMetadata metadata = new DefaultMetadata("testGroup", "testArtifact", "1-test", "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
        RepositoryConnector connector = this.factory().newInstance((RepositorySystemSession)this.session, this.repository);
        File tmpFile = TestFileUtils.createTempFile("testFileHandleLeakage");
        ArtifactUpload artUp = new ArtifactUpload((Artifact)artifact, tmpFile);
        connector.put(Arrays.asList(artUp), null);
        Assert.assertTrue((String)"Leaking file handle in artifact upload", (boolean)tmpFile.delete());
        tmpFile = TestFileUtils.createTempFile("testFileHandleLeakage");
        MetadataUpload metaUp = new MetadataUpload((Metadata)metadata, tmpFile);
        connector.put(null, Arrays.asList(metaUp));
        Assert.assertTrue((String)"Leaking file handle in metadata upload", (boolean)tmpFile.delete());
        tmpFile = TestFileUtils.createTempFile("testFileHandleLeakage");
        ArtifactDownload artDown = new ArtifactDownload((Artifact)artifact, null, tmpFile, null);
        connector.get(Arrays.asList(artDown), null);
        new File(tmpFile.getAbsolutePath() + ".sha1").deleteOnExit();
        Assert.assertTrue((String)"Leaking file handle in artifact download", (boolean)tmpFile.delete());
        tmpFile = TestFileUtils.createTempFile("testFileHandleLeakage");
        MetadataDownload metaDown = new MetadataDownload((Metadata)metadata, null, tmpFile, null);
        connector.get(null, Arrays.asList(metaDown));
        new File(tmpFile.getAbsolutePath() + ".sha1").deleteOnExit();
        Assert.assertTrue((String)"Leaking file handle in metadata download", (boolean)tmpFile.delete());
        connector.close();
    }

    @Test
    public void testBlocking() throws NoRepositoryConnectorException, IOException {
        RepositoryConnector connector = this.factory().newInstance((RepositorySystemSession)this.session, this.repository);
        int count = 10;
        byte[] pattern = "tmpFile".getBytes("UTF-8");
        File tmpFile = TestFileUtils.createTempFile(pattern, 100000);
        List<ArtifactUpload> artUps = ConnectorTestUtils.createTransfers(ArtifactUpload.class, count, tmpFile);
        List<MetadataUpload> metaUps = ConnectorTestUtils.createTransfers(MetadataUpload.class, count, tmpFile);
        List<ArtifactDownload> artDowns = ConnectorTestUtils.createTransfers(ArtifactDownload.class, count, null);
        List<MetadataDownload> metaDowns = ConnectorTestUtils.createTransfers(MetadataDownload.class, count, null);
        connector.put(artUps, metaUps);
        connector.get(artDowns, metaDowns);
        for (int i = 0; i < count; ++i) {
            ArtifactUpload artUp = artUps.get(i);
            MetadataUpload metaUp = metaUps.get(i);
            ArtifactDownload artDown = artDowns.get(i);
            MetadataDownload metaDown = metaDowns.get(i);
            Assert.assertTrue((boolean)Transfer.State.DONE.equals((Object)artUp.getState()));
            Assert.assertTrue((boolean)Transfer.State.DONE.equals((Object)artDown.getState()));
            Assert.assertTrue((boolean)Transfer.State.DONE.equals((Object)metaUp.getState()));
            Assert.assertTrue((boolean)Transfer.State.DONE.equals((Object)metaDown.getState()));
        }
        connector.close();
    }

    @Test
    public void testMkdirConcurrencyBug() throws IOException, NoRepositoryConnectorException {
        RepositoryConnector connector = this.factory().newInstance((RepositorySystemSession)this.session, this.repository);
        File artifactFile = TestFileUtils.createTempFile("mkdirsBug0");
        File metadataFile = TestFileUtils.createTempFile("mkdirsBug1");
        int numTransfers = 2;
        ArtifactUpload[] artUps = new ArtifactUpload[numTransfers];
        MetadataUpload[] metaUps = new MetadataUpload[numTransfers];
        for (int i = 0; i < numTransfers; ++i) {
            DefaultArtifact art = new DefaultArtifact("testGroup", "testArtifact", "", "jar", i + "-test");
            DefaultMetadata meta = new DefaultMetadata("testGroup", "testArtifact", i + "-test", "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
            ArtifactUpload artUp = new ArtifactUpload((Artifact)art, artifactFile);
            MetadataUpload metaUp = new MetadataUpload((Metadata)meta, metadataFile);
            artUps[i] = artUp;
            metaUps[i] = metaUp;
        }
        connector.put(Arrays.asList(artUps), null);
        connector.put(null, Arrays.asList(metaUps));
        File localRepo = this.session.getLocalRepository().getBasedir();
        StringBuilder localPath = new StringBuilder(localRepo.getAbsolutePath());
        for (int i = 0; i < 50; ++i) {
            localPath.append("/d");
        }
        ArtifactDownload[] artDowns = new ArtifactDownload[numTransfers];
        MetadataDownload[] metaDowns = new MetadataDownload[numTransfers];
        for (int m = 0; m < 20; ++m) {
            for (int i = 0; i < numTransfers; ++i) {
                File artFile = new File(localPath.toString() + "/a" + i);
                File metaFile = new File(localPath.toString() + "/m" + i);
                DefaultArtifact art = new DefaultArtifact("testGroup", "testArtifact", "", "jar", i + "-test");
                DefaultMetadata meta = new DefaultMetadata("testGroup", "testArtifact", i + "-test", "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
                ArtifactDownload artDown = new ArtifactDownload((Artifact)art, null, artFile, "fail");
                MetadataDownload metaDown = new MetadataDownload((Metadata)meta, null, metaFile, "fail");
                artDowns[i] = artDown;
                metaDowns[i] = metaDown;
            }
            connector.get(Arrays.asList(artDowns), Arrays.asList(metaDowns));
            for (int j = 0; j < numTransfers; ++j) {
                ArtifactDownload artDown = artDowns[j];
                MetadataDownload metaDown = metaDowns[j];
                Assert.assertNull((String)("artifact download had exception: " + artDown.getException()), (Object)artDown.getException());
                Assert.assertNull((String)("metadata download had exception: " + metaDown.getException()), (Object)metaDown.getException());
                Assert.assertEquals((Object)Transfer.State.DONE, (Object)artDown.getState());
                Assert.assertEquals((Object)Transfer.State.DONE, (Object)metaDown.getState());
            }
            TestFileUtils.delete(localRepo);
        }
        connector.close();
    }

    @Test
    public void testTransferZeroBytesFile() throws IOException, NoRepositoryConnectorException {
        File emptyFile = TestFileUtils.createTempFile("");
        DefaultArtifact artifact = new DefaultArtifact("gid:aid:ext:ver");
        ArtifactUpload upA = new ArtifactUpload((Artifact)artifact, emptyFile);
        File dir = TestFileUtils.createTempDir("con-test");
        File downAFile = new File(dir, "downA.file");
        downAFile.deleteOnExit();
        ArtifactDownload downA = new ArtifactDownload((Artifact)artifact, "", downAFile, "fail");
        DefaultMetadata metadata = new DefaultMetadata("gid", "aid", "ver", "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
        MetadataUpload upM = new MetadataUpload((Metadata)metadata, emptyFile);
        File downMFile = new File(dir, "downM.file");
        downMFile.deleteOnExit();
        MetadataDownload downM = new MetadataDownload((Metadata)metadata, "", downMFile, "fail");
        RepositoryConnector connector = this.factory().newInstance((RepositorySystemSession)this.session, this.repository);
        connector.put(Arrays.asList(upA), Arrays.asList(upM));
        connector.get(Arrays.asList(downA), Arrays.asList(downM));
        Assert.assertNull((String)String.valueOf(upA.getException()), (Object)upA.getException());
        Assert.assertNull((String)String.valueOf(upM.getException()), (Object)upM.getException());
        Assert.assertNull((String)String.valueOf(downA.getException()), (Object)downA.getException());
        Assert.assertNull((String)String.valueOf(downM.getException()), (Object)downM.getException());
        Assert.assertEquals((long)0L, (long)downAFile.length());
        Assert.assertEquals((long)0L, (long)downMFile.length());
        connector.close();
    }

    @Test
    public void testProgressEventsDataBuffer() throws UnsupportedEncodingException, IOException, NoSuchAlgorithmException, NoRepositoryConnectorException {
        byte[] bytes = "These are the test contents.\n".getBytes("UTF-8");
        int count = 120000;
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        for (int i = 0; i < count; ++i) {
            digest.update(bytes);
        }
        byte[] hash = digest.digest();
        File file = TestFileUtils.createTempFile(bytes, count);
        DefaultArtifact artifact = new DefaultArtifact("gid:aid:ext:ver");
        ArtifactUpload upA = new ArtifactUpload((Artifact)artifact, file);
        File dir = TestFileUtils.createTempDir("con-test");
        File downAFile = new File(dir, "downA.file");
        downAFile.deleteOnExit();
        ArtifactDownload downA = new ArtifactDownload((Artifact)artifact, "", downAFile, "fail");
        DefaultMetadata metadata = new DefaultMetadata("gid", "aid", "ver", "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
        MetadataUpload upM = new MetadataUpload((Metadata)metadata, file);
        File downMFile = new File(dir, "downM.file");
        downMFile.deleteOnExit();
        MetadataDownload downM = new MetadataDownload((Metadata)metadata, "", downMFile, "fail");
        DigestingTransferListener listener = new DigestingTransferListener();
        this.session.setTransferListener(listener);
        RepositoryConnector connector = this.factory().newInstance((RepositorySystemSession)this.session, this.repository);
        connector.put(Arrays.asList(upA), null);
        Assert.assertArrayEquals((byte[])hash, (byte[])listener.getHash());
        listener.rewind();
        connector.put(null, Arrays.asList(upM));
        Assert.assertArrayEquals((byte[])hash, (byte[])listener.getHash());
        listener.rewind();
        connector.get(Arrays.asList(downA), null);
        Assert.assertArrayEquals((byte[])hash, (byte[])listener.getHash());
        listener.rewind();
        connector.get(null, Arrays.asList(downM));
        Assert.assertArrayEquals((byte[])hash, (byte[])listener.getHash());
        listener.rewind();
        connector.close();
    }

    private final class DigestingTransferListener
    implements TransferListener {
        private MessageDigest digest;

        private synchronized void initDigest() throws NoSuchAlgorithmException {
            this.digest = MessageDigest.getInstance("SHA-1");
        }

        public DigestingTransferListener() throws NoSuchAlgorithmException {
            this.initDigest();
        }

        public void rewind() throws NoSuchAlgorithmException {
            this.initDigest();
        }

        public void transferSucceeded(TransferEvent event) {
        }

        public void transferStarted(TransferEvent event) throws TransferCancelledException {
        }

        public synchronized void transferProgressed(TransferEvent event) throws TransferCancelledException {
            this.digest.update(event.getDataBuffer());
        }

        public void transferInitiated(TransferEvent event) throws TransferCancelledException {
        }

        public void transferFailed(TransferEvent event) {
        }

        public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        }

        public synchronized byte[] getHash() {
            return this.digest.digest();
        }
    }
}

