/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.internal.test.util.ArtifactDefinition;
import org.eclipse.aether.internal.test.util.NodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyGraphParser {
    private Map<String, DependencyNode> nodes = new HashMap<String, DependencyNode>();
    private String prefix = "";
    private Collection<String> substitutions;
    private Iterator<String> substitutionIterator;

    public DependencyNode parseLiteral(String dependencyGraph) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(dependencyGraph));
        DependencyNode node = this.parse(reader);
        reader.close();
        return node;
    }

    public DependencyGraphParser(String prefix, Collection<String> substitutions) {
        this.prefix = prefix;
        this.substitutions = substitutions;
    }

    public DependencyGraphParser(String prefix) {
        this(prefix, null);
    }

    public DependencyGraphParser() {
        this("");
    }

    public DependencyNode parse(String resource) throws IOException {
        URL res = this.getClass().getClassLoader().getResource(this.prefix + resource);
        if (res == null) {
            throw new IOException("Could not find classpath resource " + this.prefix + resource);
        }
        return this.parse(res);
    }

    public List<DependencyNode> parseMultiple(String resource) throws IOException {
        URL res = this.getClass().getClassLoader().getResource(this.prefix + resource);
        if (res == null) {
            throw new IOException("Could not find classpath resource " + this.prefix + resource);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(res.openStream(), "UTF-8"));
        ArrayList<DependencyNode> ret = new ArrayList<DependencyNode>();
        DependencyNode root = null;
        while ((root = this.parse(reader)) != null) {
            ret.add(root);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependencyNode parse(URL resource) throws IOException {
        InputStream stream = null;
        try {
            stream = resource.openStream();
            DependencyNode dependencyNode = this.parse(new BufferedReader(new InputStreamReader(stream, "UTF-8")));
            return dependencyNode;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private DependencyNode parse(BufferedReader in) throws IOException {
        if (this.substitutions != null) {
            this.substitutionIterator = this.substitutions.iterator();
        }
        String line = null;
        DependencyNode root = null;
        DependencyNode node = null;
        int prevLevel = 0;
        LinkedList<DependencyNode> stack = new LinkedList<DependencyNode>();
        boolean isRootNode = true;
        while ((line = in.readLine()) != null) {
            if (DependencyGraphParser.isEmpty(line = DependencyGraphParser.cutComment(line))) continue;
            if (this.isEOFMarker(line)) break;
            while (line.contains("%s")) {
                if (!this.substitutionIterator.hasNext()) {
                    throw new IllegalArgumentException("not enough substitutions to fill placeholders");
                }
                line = line.replaceFirst("%s", this.substitutionIterator.next());
            }
            LineContext ctx = DependencyGraphParser.createContext(line);
            if (prevLevel < ctx.getLevel()) {
                stack.add(node);
            }
            while (prevLevel > ctx.getLevel()) {
                stack.removeLast();
                --prevLevel;
            }
            prevLevel = ctx.getLevel();
            if (ctx.getDefinition() != null && ctx.getDefinition().isReference()) {
                DependencyNode child = this.reference(ctx.getDefinition().getReference());
                node.getChildren().add(child);
                node = child;
                continue;
            }
            node = this.build(isRootNode ? null : (DependencyNode)stack.getLast(), ctx, isRootNode);
            if (isRootNode) {
                root = node;
                isRootNode = false;
            }
            if (ctx.getDefinition() == null || !ctx.getDefinition().hasId()) continue;
            this.nodes.put(ctx.getDefinition().getId(), node);
        }
        this.nodes.clear();
        return root;
    }

    private boolean isEOFMarker(String line) {
        return line.startsWith("---");
    }

    private DependencyNode reference(String reference) {
        if (!this.nodes.containsKey(reference)) {
            throw new IllegalArgumentException("undefined reference " + reference);
        }
        return this.nodes.get(reference);
    }

    private static boolean isEmpty(String line) {
        return line == null || line.length() == 0;
    }

    private static String cutComment(String line) {
        int idx = line.indexOf(35);
        if (idx != -1) {
            line = line.substring(0, idx);
        }
        return line;
    }

    private DependencyNode build(DependencyNode parent, LineContext ctx, boolean isRoot) {
        ArtifactDefinition def = ctx.getDefinition();
        if (!isRoot && parent == null) {
            throw new IllegalArgumentException("dangling node: " + def);
        }
        if (ctx.getLevel() == 0 && parent != null) {
            throw new IllegalArgumentException("inconsistent leveling (parent for level 0?): " + def);
        }
        NodeBuilder builder = new NodeBuilder();
        if (def != null) {
            builder.artifactId(def.getArtifactId()).groupId(def.getGroupId());
            builder.ext(def.getExtension()).version(def.getVersion()).scope(def.getScope());
            builder.properties(ctx.getProperties());
        }
        DependencyNode node = builder.build();
        if (parent != null) {
            parent.getChildren().add(node);
        }
        return node;
    }

    public String dump(DependencyNode root) {
        StringBuilder ret = new StringBuilder();
        ArrayList<NodeEntry> entries = new ArrayList<NodeEntry>();
        this.addNode(root, 0, entries);
        for (NodeEntry nodeEntry : entries) {
            char[] level = new char[nodeEntry.getLevel() * 3];
            Arrays.fill(level, ' ');
            if (level.length != 0) {
                level[level.length - 3] = 43;
                level[level.length - 2] = 45;
            }
            String definition = nodeEntry.getDefinition();
            ret.append(level).append(definition).append("\n");
        }
        return ret.toString();
    }

    private void addNode(DependencyNode root, int level, List<NodeEntry> entries) {
        NodeEntry entry = new NodeEntry();
        Dependency dependency = root.getDependency();
        StringBuilder defBuilder = new StringBuilder();
        if (dependency == null) {
            defBuilder.append("(null)");
        } else {
            Map properties;
            Artifact artifact = dependency.getArtifact();
            defBuilder.append(artifact.getGroupId()).append(":").append(artifact.getArtifactId()).append(":").append(artifact.getExtension()).append(":").append(artifact.getVersion());
            if (dependency.getScope() != null && !"".equals(dependency.getScope())) {
                defBuilder.append(":").append(dependency.getScope());
            }
            if ((properties = artifact.getProperties()) != null && !properties.isEmpty()) {
                for (Map.Entry prop : properties.entrySet()) {
                    defBuilder.append(";").append((String)prop.getKey()).append("=").append((String)prop.getValue());
                }
            }
        }
        entry.setDefinition(defBuilder.toString());
        entry.setLevel(level++);
        entries.add(entry);
        for (DependencyNode node : root.getChildren()) {
            this.addNode(node, level, entries);
        }
    }

    private static LineContext createContext(String line) {
        String definition;
        LineContext ctx = new LineContext();
        String[] split = line.split("- ");
        if (split.length == 1) {
            ctx.setLevel(0);
            definition = split[0];
        } else {
            ctx.setLevel((int)Math.ceil((double)split[0].length() / 3.0));
            definition = split[1];
        }
        if ("(null)".equalsIgnoreCase(definition)) {
            return ctx;
        }
        split = definition.split(";");
        ctx.setDefinition(new ArtifactDefinition(split[0]));
        if (split.length > 1) {
            HashMap<String, String> props = new HashMap<String, String>();
            for (int i = 1; i < split.length; ++i) {
                String[] keyValue = split[i].split("=");
                String key = keyValue[0];
                String value = keyValue[1];
                props.put(key, value);
            }
            ctx.setProperties(props);
        }
        return ctx;
    }

    public Collection<String> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(Collection<String> substitutions) {
        this.substitutions = substitutions;
    }

    public void setSubstitutions(String ... substitutions) {
        this.setSubstitutions(Arrays.asList(substitutions));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LineContext {
        ArtifactDefinition definition;
        private Map<String, String> properties;
        int level;

        LineContext() {
        }

        public ArtifactDefinition getDefinition() {
            return this.definition;
        }

        public void setDefinition(ArtifactDefinition definition) {
            this.definition = definition;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeEntry {
        int level;
        String definition;
        Map<String, String> properties;

        NodeEntry() {
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }
    }
}

