/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.internal.impl.GraphNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GraphEdge
implements DependencyNode {
    private GraphNode target;
    private Dependency dependency;
    private String context;
    private String premanagedScope;
    private String premanagedVersion;
    private List<Artifact> relocations;
    private VersionConstraint versionConstraint;
    private Version version;
    private Map<Object, Object> data = Collections.emptyMap();

    public GraphEdge(GraphNode target) {
        this.target = target;
    }

    public GraphNode getTarget() {
        return this.target;
    }

    public List<DependencyNode> getChildren() {
        return this.getTarget().getOutgoingEdges();
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
    }

    public void setArtifact(Artifact artifact) {
        this.dependency = this.dependency.setArtifact(artifact);
    }

    public List<RemoteRepository> getRepositories() {
        return this.getTarget().getRepositories();
    }

    public void setScope(String scope) {
        this.dependency = this.dependency.setScope(scope);
    }

    public String getPremanagedScope() {
        return this.premanagedScope;
    }

    public void setPremanagedScope(String premanagedScope) {
        this.premanagedScope = premanagedScope;
    }

    public String getPremanagedVersion() {
        return this.premanagedVersion;
    }

    public void setPremanagedVersion(String premanagedVersion) {
        this.premanagedVersion = premanagedVersion;
    }

    public String getRequestContext() {
        return this.context;
    }

    public void setRequestContext(String context) {
        this.context = context != null ? context : "";
    }

    public List<Artifact> getRelocations() {
        return this.relocations;
    }

    public void setRelocations(List<Artifact> relocations) {
        this.relocations = relocations == null || relocations.isEmpty() ? Collections.emptyList() : relocations;
    }

    public Collection<Artifact> getAliases() {
        return this.getTarget().getAliases();
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public void setVersionConstraint(VersionConstraint versionConstraint) {
        this.versionConstraint = versionConstraint;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Map<Object, Object> getData() {
        return this.data;
    }

    public void setData(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            if (!this.data.isEmpty()) {
                this.data.remove(key);
                if (this.data.isEmpty()) {
                    this.data = Collections.emptyMap();
                }
            }
        } else {
            if (this.data.isEmpty()) {
                this.data = new HashMap<Object, Object>();
            }
            this.data.put(key, value);
        }
    }

    public boolean accept(DependencyVisitor visitor) {
        if (visitor.visitEnter((DependencyNode)this)) {
            DependencyNode child;
            List<DependencyNode> children = this.getChildren();
            int n = children.size();
            for (int i = 0; i < n && (child = children.get(i)).accept(visitor); ++i) {
            }
        }
        return visitor.visitLeave((DependencyNode)this);
    }

    public String toString() {
        Dependency dep = this.getDependency();
        if (dep == null) {
            return String.valueOf(this.getChildren());
        }
        return dep.toString();
    }
}

