/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.basic;

import java.nio.ByteBuffer;
import org.eclipse.aether.connector.basic.ChecksumCalculator;
import org.eclipse.aether.spi.connector.Transfer;
import org.eclipse.aether.spi.connector.transport.TransportListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransferTransportListener<T extends Transfer>
extends TransportListener {
    private final T transfer;
    private final TransferListener listener;
    private final TransferEvent.Builder eventBuilder;
    private ChecksumCalculator checksums;

    protected TransferTransportListener(T transfer, TransferEvent.Builder eventBuilder) {
        this.transfer = transfer;
        this.listener = transfer.getListener();
        this.eventBuilder = eventBuilder;
    }

    protected T getTransfer() {
        return this.transfer;
    }

    public void transferInitiated() throws TransferCancelledException {
        if (this.listener != null) {
            this.eventBuilder.resetType(TransferEvent.EventType.INITIATED);
            this.listener.transferInitiated(this.eventBuilder.build());
        }
    }

    public void transportStarted(long dataOffset, long dataLength) throws TransferCancelledException {
        if (this.checksums != null) {
            this.checksums.init(dataOffset);
        }
        if (this.listener != null) {
            this.eventBuilder.resetType(TransferEvent.EventType.STARTED).setTransferredBytes(dataOffset);
            TransferEvent event = this.eventBuilder.build();
            event.getResource().setContentLength(dataLength).setResumeOffset(dataOffset);
            this.listener.transferStarted(event);
        }
    }

    public void transportProgressed(ByteBuffer data) throws TransferCancelledException {
        if (this.checksums != null) {
            this.checksums.update(data);
        }
        if (this.listener != null) {
            this.eventBuilder.resetType(TransferEvent.EventType.PROGRESSED).addTransferredBytes((long)data.remaining()).setDataBuffer(data);
            this.listener.transferProgressed(this.eventBuilder.build());
        }
    }

    public void transferCorrupted(Exception exception) throws TransferCancelledException {
        if (this.listener != null) {
            this.eventBuilder.resetType(TransferEvent.EventType.CORRUPTED).setException(exception);
            this.listener.transferCorrupted(this.eventBuilder.build());
        }
    }

    public void transferFailed(Exception exception, int classification) {
        if (this.listener != null) {
            this.eventBuilder.resetType(TransferEvent.EventType.FAILED).setException(exception);
            this.listener.transferFailed(this.eventBuilder.build());
        }
    }

    public void transferSucceeded() {
        if (this.listener != null) {
            this.eventBuilder.resetType(TransferEvent.EventType.SUCCEEDED);
            this.listener.transferSucceeded(this.eventBuilder.build());
        }
    }

    public ChecksumCalculator getChecksums() {
        return this.checksums;
    }

    public void setChecksums(ChecksumCalculator checksums) {
        this.checksums = checksums;
    }
}

