/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.types;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.eclipse.aether.internal.ant.AntRepoSys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Authentication
extends DataType {
    private String username;
    private String password;
    private String privateKeyFile;
    private String passphrase;
    private List<String> servers = new ArrayList<String>();

    public void setProject(Project project) {
        super.setProject(project);
        AntRepoSys.getInstance(project).addAuthentication(this);
    }

    protected Authentication getRef() {
        return (Authentication)((Object)this.getCheckedRef());
    }

    public void setRefid(Reference ref) {
        if (this.username != null || this.password != null || this.privateKeyFile != null || this.passphrase != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(ref);
    }

    public String getUsername() {
        if (this.isReference()) {
            return this.getRef().getUsername();
        }
        return this.username;
    }

    public void setUsername(String username) {
        this.checkAttributesAllowed();
        this.username = username;
    }

    public String getPassword() {
        if (this.isReference()) {
            return this.getRef().getPassword();
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.checkAttributesAllowed();
        this.password = password;
    }

    public String getPrivateKeyFile() {
        if (this.isReference()) {
            return this.getRef().getPrivateKeyFile();
        }
        return this.privateKeyFile;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.checkAttributesAllowed();
        this.privateKeyFile = privateKeyFile;
    }

    public String getPassphrase() {
        if (this.isReference()) {
            return this.getRef().getPassphrase();
        }
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.checkAttributesAllowed();
        this.passphrase = passphrase;
    }

    public List<String> getServers() {
        if (this.isReference()) {
            return this.getRef().getServers();
        }
        return this.servers;
    }

    public void setServers(String servers) {
        String[] split;
        this.checkAttributesAllowed();
        this.servers.clear();
        for (String server : split = servers.split("[;:]")) {
            if ((server = server.trim()).length() <= 0) continue;
            this.servers.add(server);
        }
    }
}

